/***************************************************************************
                             ksobjectfactory.cpp
                             -------------------
    begin                : Tue Oct 16 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksobjectfactory.h"
#include <qobject.h>
#include <qmetaobject.h>
#include <qbuffer.h>
#include <qdragobject.h>
#include <qapplication.h>
#include <qclipboard.h>

#include "widgets/qsaxis.h"
#include "widgets/qsclegend.h"
#include "widgets/qsaxes2d.h"
#include "widgets/qsaxes3d.h"
#include "widgets/qscurve.h"
#include "widgets/qscontour.h"
#include "widgets/qsimage.h"
#include "widgets/qssurface.h"
#include "widgets/qsfigure.h"
#include "qscobjects.h"
#include "ksworkbook.h"
#include "ksmatrix.h"
#include "ksglobalmatrixlist.h"


//-------------------------------------------------------------//

KSObjectFactory::KSObjectFactory( KSWorkbook *workbook )
: QSObjectFactory()
 {
  m_workbook = workbook;
 }

//-------------------------------------------------------------//

KSObjectFactory::~KSObjectFactory()
 {
 }

//-------------------------------------------------------------//

QSSerializable *KSObjectFactory::loadObjectFromStream( QDataStream& stream, QObject *parent )
 {
  QCString class_name;
  stream >> class_name;
  QSSerializable *result = createObject( class_name, parent );
  if ( result ) result->loadStateFromStream( stream, this );	
  return result;
 }

//-------------------------------------------------------------//

void KSObjectFactory::saveObjectToStream( QSSerializable *object, QDataStream& stream )
 {
  QSSerializable *new_object = transform_object( object, m_flags );
  stream << className( new_object );
  if ( new_object ) new_object->saveStateToStream( stream, this );
  if ( new_object != object ) delete new_object;
 }

 //-------------------------------------------------------------//

QCString KSObjectFactory::className( QSSerializable *object )
 {
  QSCObject *cobject = dynamic_cast<QSCObject*>(object);
  if ( dynamic_cast<KSMatrixFormula*>(object) ) {
	return "KSMatrixFormula";
	}
  if ( dynamic_cast< KSMatrixImpl<double>* >(object) ) {
	return "KSMatrixImpl<double>";
	}
  else if ( dynamic_cast< KSMatrixImpl<float>* >(object) ) {
	return "KSMatrixImpl<float>";
	}
  else if ( dynamic_cast< KSMatrixImpl<long int>* >(object) ) {
	return "KSMatrixImpl<long>";
	}
  else if ( dynamic_cast< KSMatrixImpl<unsigned short int>* >(object) ) {
	return "KSMatrixImpl<ushort>";
	}
  else if ( dynamic_cast< KSMatrixImpl<short int>* >(object) ) {
	return "KSMatrixImpl<short>";
	}
  else if ( dynamic_cast< KSMatrixImpl<unsigned char>* >(object) ) {
	return "KSMatrixImpl<uchar>";
	}
  // inherits QSCGroup also
  else if ( cobject && cobject->isAxesShadow() && dynamic_cast<QSAxes2D*>(cobject->parentAxes()) ) {
	return "QSCAxes2DShadow";
	}
  // inherits QSCGroup also
  else if ( cobject && cobject->isAxesShadow() && dynamic_cast<QSAxes3D*>(cobject->parentAxes()) ) {
	return "QSCAxes3DShadow";
	}
  else if ( dynamic_cast<QSAxis*>(object) && dynamic_cast<QSAxis*>(object)->type() == QSAxis::XAxisType ) {
	return "QSAxis-X";
	}
  else if ( dynamic_cast<QSAxis*>(object) && dynamic_cast<QSAxis*>(object)->type() == QSAxis::YAxisType ) {
	return "QSAxis-Y";
	}
  else if ( dynamic_cast<QSAxis*>(object) && dynamic_cast<QSAxis*>(object)->type() == QSAxis::ZAxisType ) {
	return "QSAxis-Z";
	}
  else if ( dynamic_cast<QSAxis*>(object) && dynamic_cast<QSAxis*>(object)->type() == QSAxis::VAxisType ) {
	return "QSAxis-V";
	}
  else if ( dynamic_cast<QSAxis*>(object) ) {
	return "QSAxis-Unknown";
	}
  else if ( dynamic_cast<QSCObjectCollection*>(object) ) {
	return "QSCObjectCollection";
	}
  else if ( dynamic_cast<QObject*>(object) ) {	
	return dynamic_cast<QObject*>(object)->metaObject()->className();
	}
  else {
  	return "NULL";
	}
 }

//-------------------------------------------------------------//

QSSerializable *KSObjectFactory::createObject( const QCString& class_name, QObject *parent )
 {
  if ( class_name == "QSCObjectCollection" ) {
	// no auto delete
	return new QSCObjectCollection(parent,false);
	}
  if ( class_name == "QSCGroup" ) {
	return new QSCGroup();
	}
  else if ( class_name == "QSCLegend" ) {
	return new QSCLegend(dynamic_cast<QSAxes*>(parent));
	}
  else if ( class_name == "QSCLabel" ) {
	return new QSCLabel();
	}
  else if ( class_name == "QSCArrow" ) {
	return new QSCArrow();
	}
  else if ( class_name == "QSCRect" ) {
	return new QSCRect();
	}
  else if ( class_name == "QSAxes2D" ) {
	return new QSAxes2D();
	}
  else if ( class_name == "QSAxes3D" ) {
	return new QSAxes3D();
	}
  else if ( class_name == "QSCAxes2DShadow" ) {
	QSAxes2D *result = new QSAxes2D();
	return result->shadowObject();
	}
  else if ( class_name == "QSCAxes3DShadow" ) {
	QSAxes3D *result = new QSAxes3D();
	return result->shadowObject();
	}
  else if ( class_name == "QSAxis-X" ) {
	return new QSAxis(QSAxis::XAxisType,dynamic_cast<QSAxes*>(parent));
	}
  else if ( class_name == "QSAxis-Y" ) {
	return new QSAxis(QSAxis::YAxisType,dynamic_cast<QSAxes*>(parent));
	}
  else if ( class_name == "QSAxis-Z" ) {
	return new QSAxis(QSAxis::ZAxisType,dynamic_cast<QSAxes*>(parent));
	}
  else if ( class_name == "QSAxis-V" ) {
	return new QSAxis(QSAxis::VAxisType,dynamic_cast<QSAxes*>(parent));
	}
  else if ( class_name == "QSAxis-Unknown" ) {
	return new QSAxis(QSAxis::UnknownAxisType,dynamic_cast<QSAxes*>(parent));	
	}
  else if ( class_name == "QSCurve" ) {
	return new QSCurve(dynamic_cast<QSAxes*>(parent));
	}
  else if ( class_name == "QSGriddedContour" ) {
	return new QSGriddedContour(dynamic_cast<QSAxes*>(parent));
	}
  else if ( class_name == "QSNonGriddedContour" ) {
	return new QSNonGriddedContour(dynamic_cast<QSAxes*>(parent));
	}
  else if ( class_name == "QSImage" ) {
	return new QSImage(dynamic_cast<QSAxes*>(parent));
	}
  else if ( class_name == "QSSurface" ) {
	return new QSSurface(dynamic_cast<QSAxes*>(parent));
	}
  else if ( class_name == "QSFigure" ) {
	return new QSFigure(dynamic_cast<QSAxes*>(parent));
	}
  else if ( class_name == "KSMatrixString" ) {
	return new KSMatrixString();
	}
  else if ( class_name == "KSMatrixFormula" ) {
	return new KSMatrixFormula();
	}
  else if ( class_name == "KSMatrixWorksheetCellRange" ) {
	return new KSMatrixWorksheetCellRange( m_workbook );
	}
  else if ( class_name == "KSMatrixImpl<double>" ) {
	return KSMatrix::create( EDouble );
	}
  else if ( class_name == "KSMatrixImpl<float>" ) {
	return KSMatrix::create( EFloat );
	}
  else if ( class_name == "KSMatrixImpl<long>" ) {
	return KSMatrix::create( ELong );
	}
  else if ( class_name == "KSMatrixImpl<ushort>" ) {
	return KSMatrix::create( EUShort );
	}
  else if ( class_name == "KSMatrixImpl<short>" ) {
	return KSMatrix::create( EShort );
	}
  else if ( class_name == "KSMatrixImpl<uchar>" ) {
	return KSMatrix::create( EUChar );
	}
  else if ( class_name == "KSSheet" ) {
	return new KSSheet( dynamic_cast<KSSheetList*>(parent) );
	}
  return NULL;
 }

//-------------------------------------------------------------//

void KSObjectFactory::copyToClipboard( QSSerializable *object, const QCString& format )
 {
  if ( object ) {
	QBuffer buffer;
	buffer.open( IO_WriteOnly );
	QDataStream data_stream( &buffer );
	saveObjectToStream( object, data_stream );
  	QStoredDrag *drag = new QStoredDrag( format );
  	drag->setEncodedData( buffer.buffer() );
  	QApplication::clipboard()->setData(drag);
	}
 }

//-------------------------------------------------------------//

QSSerializable *KSObjectFactory::pasteFromClipboard( const QCString& format, QObject *parent )
 {
  QMimeSource *src = QApplication::clipboard()->data();
  QBuffer buffer( src->encodedData(format) );
  buffer.open( IO_ReadOnly );
  QDataStream data_stream( &buffer );
  return loadObjectFromStream( data_stream, parent );	
 }

//-------------------------------------------------------------//

void KSObjectFactory::copyQSCObjectToClipboard( QSCObject *object )
 {
  copyToClipboard( object, "application/x-kmatplot-qscobject" );
 }

//-------------------------------------------------------------//

QSCObject *KSObjectFactory::pasteQSCObjectFromClipboard()
 {
  QSSerializable *result = pasteFromClipboard( "application/x-kmatplot-qscobject" );
  assert( !result || dynamic_cast<QSCObject*>(result) );
  return (QSCObject *)result;
 }

//-------------------------------------------------------------//

void KSObjectFactory::copyQSCObjectCollectionToClipboard( QSCObjectCollection *objects )
 {
  copyToClipboard( objects, "application/x-kmatplot-qscobjectcollection" );
 }

//-------------------------------------------------------------//

QSCObjectCollection *KSObjectFactory::pasteQSCObjectCollectionFromClipboard()
 {
  QSSerializable *result = pasteFromClipboard( "application/x-kmatplot-qscobjectcollection" );
  assert( !result || dynamic_cast<QSCObjectCollection*>(result) );
  return (QSCObjectCollection *)result;
 }

//-------------------------------------------------------------//

void KSObjectFactory::copyQSPlotToClipboard( QSPlot *dataset )
 {
  copyToClipboard( dataset, "application/x-kmatplot-qsplot" );
 }

//-------------------------------------------------------------//

QSPlot *KSObjectFactory::pasteQSPlotFromClipboard( QSAxes *parentAxes )
 {
  QSSerializable *result = pasteFromClipboard( "application/x-kmatplot-qsplot", parentAxes);
  assert( !result || dynamic_cast<QSPlot*>(result) );
  return (QSPlot *)result;
 }

//-------------------------------------------------------------//

void KSObjectFactory::copyQSAxisToClipboard( QSAxis *axis )
 {
  copyToClipboard( axis, "application/x-kmatplot-qsaxis" );
 }

//-------------------------------------------------------------//

QSAxis *KSObjectFactory::pasteQSAxisFromClipboard( QSAxes *parentAxes )
 {
  QSSerializable *result = pasteFromClipboard( "application/x-kmatplot-qsaxis", parentAxes);
  assert( !result || dynamic_cast<QSAxis*>(result) );
  return (QSAxis *)result;
 }

//-------------------------------------------------------------//

void KSObjectFactory::copyQSMatrixToClipboard( QSMatrix *matrix )
 {
  copyToClipboard( matrix, "application/x-kmatplot-qsmatrix" );
 }

//-------------------------------------------------------------//

QSMatrix *KSObjectFactory::pasteQSMatrixFromClipboard()
 {
  QSSerializable *result = pasteFromClipboard( "application/x-kmatplot-qsmatrix" );
  assert( !result || dynamic_cast<QSMatrix*>(result) );
  return (QSMatrix *)result;
 }

//-------------------------------------------------------------//

void KSObjectFactory::copyKSSheetToClipboard( KSSheet *sheet )
 {
  copyToClipboard( sheet, "application/x-kmatplot-kssheet" );
 }

//-------------------------------------------------------------//

KSSheet *KSObjectFactory::pasteKSSheetFromClipboard( KSSheetList *parent )
 {
  QSSerializable *result = pasteFromClipboard( "application/x-kmatplot-kssheet",parent );
  assert( !result || dynamic_cast<KSSheet*>(result) );
  return (KSSheet *)result;
 }

//-------------------------------------------------------------//

QSMatrix *KSObjectFactory::cloneMatrix( QSMatrix *matrix, bool copy )
 {
  if ( matrix->isString() ) {
	KSMatrixString *result = new KSMatrixString();
	if ( copy ) result->setMatrix( matrix );
	return result;
	}
  else if ( dynamic_cast<KSMatrix*>(matrix) ) {
	KSMatrix *result = KSMatrix::create( dynamic_cast<KSMatrix*>(matrix)->type() );
	if ( copy ) result->setMatrix( matrix );
	return result;
	}
  else {
	KSMatrix *result = KSMatrix::create( EDouble );	
	if ( copy ) result->setMatrix( matrix );
	return result;
	}

  return NULL;
 }

//-------------------------------------------------------------//

QSSerializable *KSObjectFactory::transform_object( QSSerializable *object, int flags )
 {
  // little hack
  if ( flags & CopyAllData && dynamic_cast<KSMatrixWorksheetCellRange*>(object) )
	return cloneMatrix( (KSMatrixWorksheetCellRange*)object, true );
  return object;
 }




