/***************************************************************************
                              ksmatrixeditor.h
                             -------------------
    begin                : 
    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSMATRIXEDITOR_H
#define KSMATRIXEDITOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qtable.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include "ksmatrix.h"
#include "ksglobalmatrixlist.h"

/**
  * Base interface for matrix editors. It is an interface and not a base class
  * because QtDesigner cant generate dialogs which inherits from custom classes.
  */
class KSMatrixEditorInterf {
	public:
	 KSMatrixEditorInterf() {}
	 virtual ~KSMatrixEditorInterf() {}
	 virtual void setColumnTitles( const QStringList& ) {}
	 virtual QPoint editorContentsPos() { return QPoint(); }
	 virtual void setEditorContentsPos( const QPoint& ) {}
	 virtual void setSelectionRange( const QRect& rect ) {}
	 virtual QRect selectionRange() { return QRect(); }
	 virtual void updateContents() {}
	 virtual QSMatrix *editedMatrix() { return NULL; }
	 virtual QWidget *widget() = 0;
	};


//--------------------------------------------------------------------------------------------------//

class KSWorkbook;
/**
  * Generic, fast matrix editor based on QTable.
  * @author Kamil Dobkowski
  */
class KSMatrixEditor : public QTable, public KSMatrixEditorInterf {
	Q_OBJECT
  public:
  	KSMatrixEditor( KSWorkbook *workbook, QSMatrix *matrix, QWidget *parent );
        virtual ~KSMatrixEditor();
	virtual void setSelectionRange( const QRect& rect );
	virtual QRect selectionRange();
	virtual void updateContents();
	virtual QSMatrix *editedMatrix() { return m_buffer; }
	virtual QPoint editorContentsPos();
	virtual void setEditorContentsPos( const QPoint& pos );
        virtual void setColumnTitles( const QStringList& list );
	virtual QWidget *widget();

  	virtual void setItem ( int row, int col, QTableItem * item );
  	virtual QTableItem* item ( int row, int col ) const;
	virtual void paintCell( QPainter *p, int row, int col, const QRect & cr, bool selected );
   	virtual QRect cellGeometry ( int row, int col ) const;

    public slots:
	virtual void slotCopy();
	virtual void slotPaste();
	virtual void slotSelectRange();
	virtual void slotFillRangeWithValue();
	virtual void slotFillRangeWithFormula();
	virtual void slotFillRangeWithUniformNoise();
	virtual void slotFillRowsMonotone();
	virtual void slotFillColsMonotone();
	virtual void slotInsertRowBefore();
	virtual void slotInsertRowAfter();
	virtual void slotInsertColBefore();
	virtual void slotInsertColAfter();
	virtual void slotRemoveRows();
	virtual void slotRemoveCols();
	virtual void slotStatistics();
	
   protected slots:
 	void slot_button_pressed( int row, int col, int button, const QPoint& pos );

   protected:
	bool isFilledSelectedCell( int row, int col );

	virtual void resizeData ( int len );
	virtual QWidget* createEditor ( int row, int col, bool initFromCell ) const;
	virtual void setCellContentFromEditor ( int row, int col );
	virtual void endEdit ( int row, int col, bool accept, bool replace );
	virtual void paintEmptyArea ( QPainter * p, int cx, int cy, int cw, int ch );
	virtual bool isValidCell( int row, int col ) const;
        virtual void insertWidget ( int row, int col, QWidget * w );
	virtual QWidget *cellWidget ( int row, int col ) const;
	virtual void clearCellWidget ( int row, int col );

   	QSMatrix *m_buffer;
	KSWorkbook *m_workbook;
	bool m_reference;
	bool m_editable;
	bool m_applying;
  };

//--------------------------------------------------------------------------------------------------//

/**
  * Adds editing column types and titles to the generic matrix editor.
  * @author Kamil Dobkowski
  */
class KSMatrixSheetEditor : public KSMatrixEditor {
   Q_OBJECT
   public:
	KSMatrixSheetEditor( KSWorkbook *workbook, KSSheet *sheet, QWidget *parent );
	virtual ~KSMatrixSheetEditor();
        virtual bool eventFilter ( QObject *o, QEvent *e );
	virtual void updateContents();
   public slots:
	virtual void slotInsertColBefore();
	virtual void slotInsertColAfter();
	virtual void slotRemoveCols();
   protected:
	void headerDoubleClick( int column );
	void makeHeaders();
	KSSheet *m_sheet;
  };



#endif
