/***************************************************************************
                            ksglobalsettings.cpp
                             -------------------
    begin                : Mon Jan 14 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksglobalsettings.h"
#include "ksworkbook.h"
#include <qsettings.h>


KSGlobalSettings::settings_t KSGlobalSettings::m_settings;

//--------------------------------------------------------------------------//

KSGlobalSettings::KSGlobalSettings()
 {
 }

//--------------------------------------------------------------------------//

KSGlobalSettings::~KSGlobalSettings()
 {
 }

 //--------------------------------------------------------------------------//

void KSGlobalSettings::setOpenSocket( bool enable )
 {
  m_settings.m_open_socket = enable;
 }
	
 //--------------------------------------------------------------------------//

bool KSGlobalSettings::openSocket()
 {
  return m_settings.m_open_socket;
 }

 //--------------------------------------------------------------------------//

void KSGlobalSettings::setUndoLevels( int levels )
 {
  m_settings.m_undo_levels = levels;
 }

 //--------------------------------------------------------------------------//

int KSGlobalSettings::undoLevels()
 {
  return m_settings.m_undo_levels;
 }

 //--------------------------------------------------------------------------//

void KSGlobalSettings::setUseCustomPrintDpi( bool enabled )
 {
  m_settings.m_use_custom_dpi = enabled;
 }

//--------------------------------------------------------------------------//

bool KSGlobalSettings::useCustomPrintDpi()
 {
  return m_settings.m_use_custom_dpi;
 }

//--------------------------------------------------------------------------//

void KSGlobalSettings::setCustomPrintDpi( int dpi )
 {
  m_settings.m_custom_dpi = dpi;
 }

//--------------------------------------------------------------------------//

int KSGlobalSettings::customPrintDpi()
 {
  return m_settings.m_custom_dpi;
 }

//--------------------------------------------------------------------------//

void KSGlobalSettings::setInstallPath( const QString& installPath )
 {
  m_settings.m_install_path = installPath;
 }

//--------------------------------------------------------------------------//

QString KSGlobalSettings::installPath()
 {
  return m_settings.m_install_path;
 }

//--------------------------------------------------------------------------//

QString KSGlobalSettings::examplePath()
 {
  return m_settings.m_install_path + "/share/kmatplot/examples";
 }

//--------------------------------------------------------------------------//

QString KSGlobalSettings::picturePath()
 {
  return m_settings.m_install_path + "/share/kmatplot/pics";
 }

//--------------------------------------------------------------------------//

#define KEY_INSTALL_PATH "/KMatplot/installPath"
#define KEY_USE_CUSTOM_DPI "/KMatplot/useCustomPrintDpi"
#define KEY_CUSTOM_DPI "/KMatplot/customPrintDpi"
#define KEY_OPEN_SOCKET "/KMatplot/openSocket"
#define KEY_UNDO_LEVELS "/KMatplot/undoLevels"

void KSGlobalSettings::load()
 {
  QSettings s;
  //s.insertSearchPath( QSettings::Unix, "/etc" );
  m_settings.m_install_path = s.readEntry( KEY_INSTALL_PATH, "/usr/local" );
  m_settings.m_use_custom_dpi = s.readBoolEntry( KEY_USE_CUSTOM_DPI, false );
  m_settings.m_custom_dpi = s.readNumEntry( KEY_CUSTOM_DPI, 360 );
  m_settings.m_open_socket = s.readBoolEntry( KEY_OPEN_SOCKET, false );
  m_settings.m_undo_levels = s.readNumEntry( KEY_UNDO_LEVELS, 5 );
 }

//--------------------------------------------------------------------------//

void KSGlobalSettings::save()
 {
  QSettings s;
  //s.insertSearchPath( QSettings::Unix, "/etc" );
  s.writeEntry( KEY_INSTALL_PATH, m_settings.m_install_path );
  s.writeEntry( KEY_USE_CUSTOM_DPI, m_settings.m_use_custom_dpi );
  s.writeEntry( KEY_CUSTOM_DPI, m_settings.m_custom_dpi );
  s.writeEntry( KEY_OPEN_SOCKET, m_settings.m_open_socket );
  s.writeEntry( KEY_UNDO_LEVELS, m_settings.m_undo_levels );
 }

//--------------------------------------------------------------------------//

void KSGlobalSettings::apply()
 {
  KSCommandHistory::setUndoLevels( m_settings.m_undo_levels );
 }

