/***************************************************************************
                              mpparsersymbol.h
                             -------------------
    begin                : Sat Nov 24 2001
    copyright            : (C) 2001 by Kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MPPARSERSYMBOL_H
#define MPPARSERSYMBOL_H

#include<qstring.h>
#include"mpsymbol.h"

/**
  * Parser symbol ( used instead an ordinary union in bison parser files.
  * It provides a memory management.
  * @author Kamil
  */
class MPParserSymbol {
  public:
	enum Type { Unknown, Token, Value, Sym, SymList };
	MPParserSymbol();
	MPParserSymbol( const MPParserSymbol& symbol );
	~MPParserSymbol();
	const MPParserSymbol &operator =( const MPParserSymbol& symbol );
	const MPParserSymbol &operator =( const QString& token );
	const MPParserSymbol &operator =( double value );
	const MPParserSymbol &operator =( MPSymbol *sym );
	const MPParserSymbol &operator =( MPSymbolList *symList );
	Type type() const;
	QString token() const;
	double value() const;
	MPSymbol *sym() const;
	MPSymbolList *symList() const;
	QString takeToken() const;
	double takeValue() const;
	MPSymbol *takeSym() const;
	MPSymbolList *takeSymList() const;

  private:
	struct shared_data_t;
	shared_data_t *m_shared_data;
};

#endif
