/***************************************************************************
                          mpparsersymbol.cpp  -  description
                             -------------------
    begin                : Sat Nov 24 2001
    copyright            : (C) 2001 by Kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mpparsersymbol.h"

//-------------------------------------------------------------------------//

struct MPParserSymbol::shared_data_t {
	MPParserSymbol::Type m_type;
	int m_ref_count;
	QString m_token;
	double m_value;
	MPSymbol *m_sym;
	MPSymbolList *m_sym_list;
	shared_data_t() {
		m_type = MPParserSymbol::Unknown;
		m_ref_count = 1;
		m_sym = NULL;
		m_sym_list = NULL;
		}	
	~shared_data_t() {
		delete m_sym;
		delete m_sym_list;
		}
	shared_data_t *addRef() {
		m_ref_count ++;
		return this;
		}
	void unref() {
		m_ref_count --;
		if ( m_ref_count == 0 ) delete this;		
		}
	};

//-------------------------------------------------------------------------//

MPParserSymbol::MPParserSymbol()
 {
  m_shared_data = new shared_data_t();
 }

//-------------------------------------------------------------------------//

MPParserSymbol::MPParserSymbol( const MPParserSymbol& symbol )
 {
  m_shared_data = symbol.m_shared_data;
  m_shared_data->addRef();
 }

//-------------------------------------------------------------------------//

MPParserSymbol::~MPParserSymbol()
 {
  m_shared_data->unref();
 }

//-------------------------------------------------------------------------//

const MPParserSymbol &MPParserSymbol::operator =( const MPParserSymbol& symbol )
 {
  m_shared_data->unref();
  m_shared_data = symbol.m_shared_data;
  m_shared_data->addRef();
  return *this;
 }

//-------------------------------------------------------------------------//

const MPParserSymbol &MPParserSymbol::operator =( const QString& token )
 {
  m_shared_data->unref();
  m_shared_data = new shared_data_t();
  m_shared_data->m_token = token;
  m_shared_data->m_type  = Token;
  return *this;
 }

//-------------------------------------------------------------------------//

const MPParserSymbol &MPParserSymbol::operator =( double value )
 {
  m_shared_data->unref();
  m_shared_data = new shared_data_t();
  m_shared_data->m_value = value;
  m_shared_data->m_type  = Value;
  return *this;
 }

//-------------------------------------------------------------------------//

const MPParserSymbol &MPParserSymbol::operator =( MPSymbol *sym )
 {
  m_shared_data->unref();
  m_shared_data = new shared_data_t();
  m_shared_data->m_sym = sym;
  m_shared_data->m_type = Sym;
  return *this;
 }

//-------------------------------------------------------------------------//

const MPParserSymbol &MPParserSymbol::operator =( MPSymbolList *symList )
 {
  m_shared_data->unref();
  m_shared_data = new shared_data_t();
  m_shared_data->m_sym_list = symList;
  m_shared_data->m_type = SymList;
  return *this;
 }

//-------------------------------------------------------------------------//

QString MPParserSymbol::takeToken() const
 {
  return m_shared_data->m_token;
 }

//-------------------------------------------------------------------------//

double MPParserSymbol::takeValue() const
 {
  return m_shared_data->m_value;
 }

//-------------------------------------------------------------------------//

MPSymbol *MPParserSymbol::takeSym() const
 {
  MPSymbol *result = m_shared_data->m_sym;
  m_shared_data->m_sym = NULL;
  m_shared_data->m_type = Unknown;
  return result;
 }

//-------------------------------------------------------------------------//

MPSymbolList *MPParserSymbol::takeSymList() const
 {
  MPSymbolList *result = m_shared_data->m_sym_list;
  m_shared_data->m_sym_list = NULL;
  m_shared_data->m_type = Unknown;
  return result;
 }

//-------------------------------------------------------------------------//

MPParserSymbol::Type MPParserSymbol::type() const
 {
  return m_shared_data->m_type;
 }

//-------------------------------------------------------------------------//

QString MPParserSymbol::token() const
 {
  return m_shared_data->m_token;
 }

//-------------------------------------------------------------------------//

double MPParserSymbol::value() const
 {
  return m_shared_data->m_value;
 }

//-------------------------------------------------------------------------//

MPSymbol *MPParserSymbol::sym() const
 {
  return m_shared_data->m_sym;
 }

//-------------------------------------------------------------------------//

MPSymbolList *MPParserSymbol::symList() const
 {
  return m_shared_data->m_sym_list;
 }


