/***************************************************************************
                               kswizarddlgs.cpp
                             -------------------
    begin                : Wed Aug 15 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include"kswizarddlgs.h"
#include"../widgets/qssurface.h"
#include"../widgets/qscontour.h"
#include"../ksmatrix.h"
#include"../kscommands.h"

#include<qspinbox.h>
#include<qcheckbox.h>


//------------------------------------------------------------------------------------//

KSWizardDlgSurface::KSWizardDlgSurface( QWidget *parent, KSWorkbook *workbook, KSSheet *sheet, QSAxes *axes, bool surface )
:KSWizardDlgSurfaceInterf( parent, NULL, TRUE )
 {
  m_sheet = sheet;
  m_axes  = axes;
  m_surface = surface;
  m_workbook = workbook;
  if ( m_surface ) {
	setCaption(tr("Surface wizard") );
	} else {
	setCaption(tr("Contour wizard") );
	colorAreaUnder->setEnabled( false );
	}
 }

//------------------------------------------------------------------------------------//

KSWizardDlgSurface::~KSWizardDlgSurface()
 {
 }

//------------------------------------------------------------------------------------//

//data->setDataObject( new_contour, QSGriddedContour::Data );
//	data->setRefObject( m_sheet, 0,
//			    rowFrom->value(), rowStep->value(), rowTo->value(),
//			    colFrom->value(), colStep->value(), colTo->value() );
//	data->setDataObject( new_surface, QSSurface::ZData );
//	data->setRefObject( m_sheet, 0,
//			    rowFrom->value(), rowStep->value(), rowTo->value(),
//			    colFrom->value(), colStep->value(), colTo->value() );
//        KSMatrixRef *data = new KSMatrixRef();
void KSWizardDlgSurface::create()
 {
  // add contour
  if ( colorAreaUnder->isChecked() || !m_surface ) {
	QSContour *new_contour = new QSGriddedContour( m_axes );	
	// data
        KSMatrixWorksheetCellRange *data = new KSMatrixWorksheetCellRange( m_workbook );
        data->setWorksheet( m_workbook->sheets()->childIndex(m_sheet) );
	data->setRowFrom( rowFrom->value() );
	data->setRowStep( rowStep->value() );
	data->setRowTo( rowTo->value() );
	data->setColFrom( colFrom->value() );
	data->setColStep( colStep->value() );
	data->setColTo( colTo->value() );			
	new_contour->setMatrix( QSGriddedContour::Data, data );

        // x-vector
	if ( isXVector->isChecked() ) {	
		KSMatrixWorksheetCellRange *x_vector = new KSMatrixWorksheetCellRange( m_workbook );
		x_vector->setWorksheet( m_workbook->sheets()->childIndex(m_sheet) );
		x_vector->setRowFrom( 0 );
		x_vector->setRowStep( 1 );
		x_vector->setRowTo( 0 );
		x_vector->setColFrom( colFrom->value() );
		x_vector->setColStep( colStep->value() );
		x_vector->setColTo( colTo->value() );
        	new_contour->setMatrix( QSGriddedContour::XVector, x_vector );
		}
	// y-vector
	if ( isYVector->isChecked() ) {
        	KSMatrixWorksheetCellRange *y_vector = new KSMatrixWorksheetCellRange( m_workbook );
        	y_vector->setWorksheet( m_workbook->sheets()->childIndex(m_sheet) );
		y_vector->setRowFrom( rowFrom->value() );
		y_vector->setRowStep( rowStep->value() );
		y_vector->setRowTo( rowTo->value() );
		y_vector->setColFrom( 0 );
		y_vector->setColStep( 1 );
		y_vector->setColTo( 0 );
        	new_contour->setMatrix( QSGriddedContour::YVector, y_vector );
		}
        // register plot
	m_workbook->execute( new KSCmdAddDataset(new_contour) );
	if ( m_surface ) { new_contour->setContourLabels( false ); }
		
	}

  // add surface
  if ( m_surface ) {
	QSSurface *new_surface = new QSSurface( m_axes );
	// data
        KSMatrixWorksheetCellRange *data = new KSMatrixWorksheetCellRange( m_workbook );
        data->setWorksheet( m_workbook->sheets()->childIndex(m_sheet) );
	data->setRowFrom( rowFrom->value() );
	data->setRowStep( rowStep->value() );
	data->setRowTo( rowTo->value() );
	data->setColFrom( colFrom->value() );
	data->setColStep( colStep->value() );
	data->setColTo( colTo->value() );
	new_surface->setMatrix( QSSurface::ZData, data );	
        // x-vector
	if ( isXVector->isChecked() ) {	
		KSMatrixWorksheetCellRange *x_vector = new KSMatrixWorksheetCellRange( m_workbook );
		x_vector->setWorksheet( m_workbook->sheets()->childIndex(m_sheet) );
		x_vector->setRowFrom( 0 );
		x_vector->setRowStep( 1 );
		x_vector->setRowTo( 0 );
		x_vector->setColFrom( colFrom->value() );
		x_vector->setColStep( colStep->value() );
		x_vector->setColTo( colTo->value() );
        	new_surface->setMatrix( QSSurface::XVector, x_vector );
		}
	// y-vector
	if ( isYVector->isChecked() ) {
        	KSMatrixWorksheetCellRange *y_vector = new KSMatrixWorksheetCellRange( m_workbook );
        	y_vector->setWorksheet( m_workbook->sheets()->childIndex(m_sheet) );
		y_vector->setRowFrom( rowFrom->value() );
		y_vector->setRowStep( rowStep->value() );
		y_vector->setRowTo( rowTo->value() );
		y_vector->setColFrom( 0 );
		y_vector->setColStep( 1 );
		y_vector->setColTo( 0 );
        	new_surface->setMatrix( QSSurface::YVector, y_vector );
		}
        // register plot
	m_workbook->execute( new KSCmdAddDataset(new_surface) );
	}
  accept();
 }

//------------------------------------------------------------------------------------//
