/***************************************************************************
                                 kssheetdlgs.cpp
                             -------------------
    begin                :
    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kssheetdlgs.h"
#include "../ksglobalmatrixlist.h"
#include "../formula/mpformula.h"
#include "../kscommands.h"
#include "../ksworkbook.h"
#include "../ksobjectfactory.h"
#include "../ksdatasymbolfactory.h"

#include<qlabel.h>
#include<qcombobox.h>
#include<qmultilineedit.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qspinbox.h>

//--------------------------------------------------------------------//
//--------------------------------------------------------------------//
//--------------------------------------------------------------------//
//--------------------------------------------------------------------//

KSSheetDlgCellRange::KSSheetDlgCellRange( QWidget *parent )
: KSSheetDlgCellRangeInterf( parent, NULL, TRUE )
 {
 }

//--------------------------------------------------------------------//

KSSheetDlgCellRange::~KSSheetDlgCellRange()
 {
 }

//--------------------------------------------------------------------//
//--------------------------------------------------------------------//
//--------------------------------------------------------------------//
//--------------------------------------------------------------------//

KSSheetDlgValueRange::KSSheetDlgValueRange( QWidget *parent )
: KSSheetDlgValueRangeInterf( parent, NULL, TRUE )
 {
 }

//--------------------------------------------------------------------//

KSSheetDlgValueRange::~KSSheetDlgValueRange()
 {
 }

//--------------------------------------------------------------------//

void KSSheetDlgValueRange::setMinValue( double value )
 {
  rangeMin->setText( QString::number(value) );
 }

//--------------------------------------------------------------------//

void KSSheetDlgValueRange::setMaxValue( double value )
 {
  rangeMax->setText( QString::number(value) );
 }

//--------------------------------------------------------------------//

double KSSheetDlgValueRange::minValue() const
 {
  return rangeMin->text().toDouble();
 }

//--------------------------------------------------------------------//

double KSSheetDlgValueRange::maxValue() const
 {
  return rangeMax->text().toDouble();
 }	

//--------------------------------------------------------------------//
//--------------------------------------------------------------------//
//--------------------------------------------------------------------//
//--------------------------------------------------------------------//

KSSheetDlgSequence::KSSheetDlgSequence( QWidget *parent )
: KSSheetDlgSequenceInterf( parent, NULL, TRUE )
 {
 }

//--------------------------------------------------------------------//

KSSheetDlgSequence::~KSSheetDlgSequence()
 {
 }

//--------------------------------------------------------------------//

double KSSheetDlgSequence::from() const
 {
  return sequenceFrom->text().toDouble();
 }

//--------------------------------------------------------------------//

double KSSheetDlgSequence::to() const
 {
  return sequenceTo->text().toDouble();
 }

//--------------------------------------------------------------------//

bool KSSheetDlgSequence::useStep() const
 {
  return sequenceUseStepValue->isChecked();
 }

//--------------------------------------------------------------------//

bool KSSheetDlgSequence::reversedDirection() const
 {
  return sequenceReversedDirection->isChecked();
 }

//--------------------------------------------------------------------//
//--------------------------------------------------------------------//
//--------------------------------------------------------------------//
//--------------------------------------------------------------------//
//--------------------------------------------------------------------//
//--------------------------------------------------------------------//

KSSheetDlgColData::KSSheetDlgColData( QWidget *parent, KSSheet *matrix, int column_from, int column_step, int column_to )
: KSSheetDlgColDataInterf( parent, NULL, TRUE )
 {
  m_global_matrix = matrix;
  m_column_from = column_from;
  m_column_step = column_step;
  m_column_to   = column_to;

  columnFrom->setValue( m_column_from );
  columnStep->setValue( m_column_step );
  columnTo->setValue( m_column_to );

  setCaption( tr("Column editor") );
  colType->clear();
  colType->insertItem( tr("Unknown") );
  colType->insertItem( tr("X") );	
  colType->insertItem( tr("Y") );
  colType->insertItem( tr("Z") );
  colType->insertItem( tr("V") );
  colType->insertItem( tr("Delta X") );
  colType->insertItem( tr("Delta Y") );
  if ( matrix->isColumnDataPresent(m_column_from) ) {
  	colTitle->setText( matrix->columnData(m_column_from).title );
	colType->setCurrentItem( matrix->columnData(m_column_from).type );
	}
 }

//--------------------------------------------------------------------//

KSSheetDlgColData::~KSSheetDlgColData()
 {
 }

//--------------------------------------------------------------------//

KSSheet::ColumnType KSSheetDlgColData::columnType() const
 {
  return static_cast<KSSheet::ColumnType >(colType->currentItem());
 }

//--------------------------------------------------------------------//

QString KSSheetDlgColData::columnTitle() const
 {
  return colTitle->text();
 }

//--------------------------------------------------------------------//

void KSSheetDlgColData::apply()
 {
  for( int curr_col=columnFrom->value(); curr_col<=columnTo->value(); curr_col+=columnStep->value() ) {
  	m_global_matrix->setColumnData( curr_col, columnType(), columnTitle() );
	}
 }




