/***************************************************************************
                                  kspanel.h
                             -------------------
    begin                : Sat Oct 7 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSPANEL_H
#define KSPANEL_H
#include<qwidget.h>
#include<qpushbutton.h>
#include<qpixmap.h>
#include"../ksworkbook.h"

//------------------------------------------------------------------------------------------------------//

class KSPanel;
class QSCObject;
class QButtonGroup;
class QSData;

/**
  * Click it and the apriopriate panel is shown.
  */
class KSPanelButton : public QPushButton {
	 Q_OBJECT
  public:
	enum ButtonCategory { BGeneral, BAxes, BDatasets, BObject };
	static KSPanelButton *categoryButton( ButtonCategory category, QWidget *parent );
	KSPanelButton( QWidget *parent, KSWorkbook *workbook, ButtonCategory category, const QPixmap& icon, const QString& toolTip = QString::null, QSData *dataObject = NULL );
	virtual ~KSPanelButton();
	virtual KSPanel *createPanel( QWidget *panelParent );
	virtual bool isButtonFor( QSCObject *object, int category, int element ) { return false; }
	ButtonCategory category() const { return m_category; }
	QSData *dataObject() const { return m_data_object; }

  protected:
	KSWorkbook *m_workbook;
	ButtonCategory m_category;
	QSData *m_data_object;
  };

//------------------------------------------------------------------------------------------------------//

/**
  *Base class for config panels
  *@author Kamil Dobkowski
  */
class KSPanel : public QWidget  {
   Q_OBJECT
 public:
	KSPanel(QWidget *parent=0, const char *name=0);
	~KSPanel();
	virtual void readProperties() = 0;
	virtual void applyProperties() = 0;
	virtual bool eventFilter( QObject*, QEvent* );

 signals:
 	void propertiesChanged();
	void message( const QString& text );
 	
 protected:
  	virtual void watchProperties();
	virtual void watch_properties_of( QObject *o );
 private slots:
  	void property_change();
  	void property_change_string(const QString&);
};

//------------------------------------------------------------------------------------------------------//

class QComboBox;
class QSAxis;
class QSAxes;

/**
  * A little tool class which provides a list of available axes to select
  */
class KSAxisSelect : public QObject
 {
  Q_OBJECT
  public:
	KSAxisSelect( QComboBox *parent, QSAxes *parentAxes, int axisType );
	virtual ~KSAxisSelect();
	void readProperties( QSAxis *selected );
	QSAxis *selectedAxis();
	QString axisName();
  private:
	QComboBox *m_parent;
	QSAxes *m_parent_axes;
	int m_axis_type;
 };

#endif
