/***************************************************************************
                               ksimportdlg.cpp
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "ksimportdlg.h"
#include "../widgets/qsdata.h"
#include "../ksworkbook.h"
#include "../ksmatrix.h"
#include "../kscommands.h"
#include "../ksmatrixio.h"
#include <qlistview.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qurl.h>
#include <qfiledialog.h>
//#include <kfiledialog.h>

QString KSImportDlg::m_file_name;

//-----------------------------------------------------------//

KSImportDlg::KSImportDlg( KSWorkbook *workbook, QSData *data, int channel, QWidget *parent, const char *name)
 : KSImportDlgInterf(parent,name,true)
 {
  m_workbook = workbook;
  m_data = data;
  m_channel = channel;

  // init the matrix list
  mlist->addColumn( tr("Name"), 270 );
  mlist->addColumn( tr("RowsCols"),  85 );
  mlist->setSorting(-1);
  mlist->setAllColumnsShowFocus( true );

  // handle some signals
  connect( bload,   SIGNAL(clicked()), this, SLOT(accept()) );
  connect( bcancel, SIGNAL(clicked()), this, SLOT(reject()) );
  connect( filename, SIGNAL(returnPressed()), this, SLOT(changedFile()) );
  connect( bbrowse,  SIGNAL(clicked()), this, SLOT(chooseFile()) );

  filename->setText( m_file_name );
  refreshFileContents();
 }

//-----------------------------------------------------------//

KSImportDlg::~KSImportDlg()
 {
 }

//-----------------------------------------------------------//

void KSImportDlg::chooseFile()
 {
  QString new_file = QFileDialog::getOpenFileName( m_file_name.isEmpty() ? QDir::homeDirPath() : m_file_name,
                     tr("*|All files (*)\n*.txt|ASCII files (*.txt)\n*.mat|MATLAB 1.0 files (*.mat)"),
		     this, "import_dialog",  tr("Import File...") );
  if ( !new_file.isEmpty() ) {
	 m_file_name = new_file;
         filename->setText( m_file_name );
         refreshFileContents();
        }
 }

//-----------------------------------------------------------//

void KSImportDlg::changedFile()
 {
  m_file_name = filename->text();
  refreshFileContents();
 }

//-----------------------------------------------------------//

void KSImportDlg::refreshFileContents()
 {
  if ( m_file_name.isEmpty() ) return;


  mlist->clear();
  KSHeadersList *headers;
  KSMatrixIO io(m_file_name);
  headers = io.loadHeaders();
  if ( !headers ) {
         QMessageBox::warning ( this, tr("Error"), tr("Unknown error !"), QMessageBox::Ok, 0, 0 );
         return;
        }

  KSHeadersList::iterator curr = headers->end();
  KSHeadersList::iterator last = headers->begin();
  while( curr != last ) {
         curr--;
         QString size = QString::null;
         int col = (*curr)->cols();
         int row = (*curr)->rows();
         if ( row && col ) size.sprintf("%dx%d ", row, col );
         (void) new QListViewItem( mlist, (*curr)->name(), size );
        }

  delete headers;
  mlist->triggerUpdate();
 }

//-----------------------------------------------------------//

void KSImportDlg::loadAll()
 {
  KSMatrixIO io(m_file_name);
  QListViewItem *mitem = mlist->selectedItem();
  if ( mitem && !mitem->text(0).isEmpty() ) {
 	KSMatrix *new_matrix = io.loadMatrix( mitem->text(0) );
	if ( new_matrix ) m_workbook->execute( new KSCmdSetData(m_data,m_channel,new_matrix) );    	
	}
 }

//-----------------------------------------------------------//




























