/***************************************************************************
                          ksgraphwizard.h  -  description
                             -------------------
    begin                : Thu Mar 14 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSGRAPHWIZARD_H
#define KSGRAPHWIZARD_H

#include <qwidget.h>
#include <qvaluevector.h>
#include <qiconview.h>
#include "ksgraphwizardinterf.h"
#include "../ksdataobjectfactory.h"


class QSAxes;
class QSPlotView;
class KSWorkbook;
class KSSheet;
class QSAxesChild;
class KSMatrixEditorInterf;

//---------------------------------------------------------------------------//

struct KSGraphChannelInfo {
	KSSheet *m_sheet;
	QPoint m_editor_pos;
	QRect m_selection;
	bool m_use_formula;
	QString m_formula;
	QString m_name;
	QString m_description;	
	KSGraphChannelInfo() { m_sheet = NULL; m_use_formula=false; }
	~KSGraphChannelInfo() {}
	};

//---------------------------------------------------------------------------//

typedef QValueVector<KSGraphChannelInfo> KSGraphInfo;

//---------------------------------------------------------------------------//

class KSGraphSubtypeItem : public QIconViewItem
 {
  public:
	KSGraphSubtypeItem( QIconView *parent, KSDataObjectFactory::DataObject objectType, const QString& title, const QString& icon );
	virtual ~KSGraphSubtypeItem();
	virtual void initChannels( KSGraphInfo *info );
	virtual QWidget *additionalPage( QWidget *parent );
	virtual QSAxesChild *createObject( QSAxes *parent );
  private:
	KSGraphInfo m_graph_info;
	KSDataObjectFactory::DataObject m_object_type;
	void show_page_1();
 };

/**
class KSGraphPreview : public QWidget
 {
  	Q_OBJECT
  public:
	void setAxes( bool axes3d );
	QSAxes *axes();
	
	
 };

  */

//---------------------------------------------------------------------------//

/**
  *@author kamil
  */
class KSGraphWizard : public KSGraphWizardInterf  {
   Q_OBJECT
public: 
	KSGraphWizard( QSPlotView *view, KSWorkbook *workbook, QWidget *parent=0, const char *name=0);
	virtual ~KSGraphWizard();
	virtual void showPage( QWidget *page );
	virtual bool eventFilter( QObject *watched, QEvent *e );
private:
	QSAxes *m_preview_axes;	
	QSAxes *m_new_axes;
	QSAxesChild *m_new_dataset;
	QSPlotView *m_view;
	KSWorkbook *m_workbook;
	KSGraphInfo m_graph_info;
	KSMatrixEditorInterf *m_sheet_editor;
	bool m_watch_data_page;

	QSAxesChild *create_graph();
	void set_watch_data_page( bool enabled );
        void show_page_data();
	void show_page_finish();
	void create_data( QSData *object );
	void clear_preview();
	void apply_dataset();

private slots:
	void slot_page_type_changed();
	void slot_graph_type_changed( int index );
	void slot_channel_selected( int index );
	void slot_clear_channel();
	void slot_channel_data_changed();
	void accept();
};

#endif
