/***************************************************************************
                               ksconfiguredlg.cpp
                             -------------------
    begin                : Mon Jan 14 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksconfiguredlg.h"
#include "../ksglobalsettings.h"
#include<qpushbutton.h>
#include<qlineedit.h>
#include<qfiledialog.h>
#include<qcheckbox.h>
#include<qspinbox.h>
#include<qtabwidget.h>
#include<qtextbrowser.h>

//----------------------------------------------------------------------------//

KSConfigureDlg::KSConfigureDlg(QWidget *parent, const char *name )
: KSConfigureDlgInterf(parent,name, TRUE)
 {
  textInstallPath->setText( KSGlobalSettings::installPath() );
  useCustomPrintDpi->setChecked( KSGlobalSettings::useCustomPrintDpi() );
  customPrintDpi->setValue( KSGlobalSettings::customPrintDpi() );
  openSocket->setChecked( KSGlobalSettings::openSocket() );
  undoLevels->setValue( KSGlobalSettings::undoLevels()   );
  connect( tabWidget, SIGNAL(currentChanged(QWidget*)), this, SLOT(currentTabChanged(QWidget*)) );
 }

//----------------------------------------------------------------------------//

KSConfigureDlg::~KSConfigureDlg()
 {
 }

//----------------------------------------------------------------------------//

void KSConfigureDlg::applySettings()
 {
  KSGlobalSettings::setInstallPath( textInstallPath->text() );
  KSGlobalSettings::setUseCustomPrintDpi( useCustomPrintDpi->isChecked() );
  KSGlobalSettings::setCustomPrintDpi( customPrintDpi->value() );
  KSGlobalSettings::setUndoLevels( undoLevels->value() );
  KSGlobalSettings::setOpenSocket( openSocket->isChecked()  );
  KSGlobalSettings::save();
  KSGlobalSettings::apply();
 }

//----------------------------------------------------------------------------//

void KSConfigureDlg::addModulePath()
 {
  QString new_module_dir = QFileDialog::getExistingDirectory();
  if ( !new_module_dir.isEmpty() ) textModulePaths->setText( textModulePaths->text() +":"+ new_module_dir );
 }

//----------------------------------------------------------------------------//

void KSConfigureDlg::setInstallPath()
 {
  QString new_install_dir = QFileDialog::getExistingDirectory();
  if ( !new_install_dir.isEmpty() ) textInstallPath->setText( new_install_dir );
 }

//----------------------------------------------------------------------------//

void KSConfigureDlg::currentTabChanged( QWidget *w )
 {
  if ( w == tabGeneral ) tabDescription->setText(tr(
	"<b>General</b>"
	"<hr>"
	"<p align=\"justify\">"
	"<i>Install path</i> - base directory where the program is installed. Kmatplot searches for its resources"
	" such as examples, help files, modules in subdirectories of this directory."
	"</p>"
	"<p align=\"justify\">"
	"<i>Custom printing resolution</i> - generate Poscript file at a given resolution. It affects line widths "
	"and printing quality - coordinates can be calculated with increased accuracy. Default resolution is 600 dpi."
	"</p>"
        "<p align=\"justify\">"
	"<i>Open socket</i> - You can feed the program with data through an unix socket. This option tells whether "
	"KMatplot should open a socket when running. Notice that it will be always opened when the program is "
	"executed from within <i>Octave</i> or <i>Scilab</i> or with a command line argument <i>--fd file_descriptor</i>. "
	"See also:<i>View/IO info</i>"
        "</p>" ) );
  else tabDescription->setText(tr(
	"<b>Sorry !</b>"
	"<hr>"
	"No help for this page.") );
 }


