/***************************************************************************
                                  ksattrpanel.h
                             -------------------
    begin                : Tue Oct 10 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSATTRPANEL_H
#define KSATTRPANEL_H

#include "ksattrpanelinterf.h"
#include "../widgets/qsgattr.h"
#include<qpen.h>
#include<qbrush.h>
#include<qcolor.h>

/** Base class for attr panels.
  * You have to set two subpanels ( arrow shape and color for example ) to use it.
  * @author Kamil Dobkowski
  */
class KSAttrPanel : public KSAttrPanelInterf  {
	Q_OBJECT
  public:
	/**
	  * Constructor
	  */
        KSAttrPanel( QWidget *parent=0, const char *name=0 );
	/**
	  * Destructor
	  */
       ~KSAttrPanel();
	/**
	  * Set the first ( left ) subpanel
	  */
        void setSubPanel1( QWidget *panel );
	/**
	  * Sets the second( right ) subpanel
	  */	
	void setSubPanel2( QWidget *panel );
	/**
	  * Returns the first subpanel ( if set ). You will have
	  * to cast it to the desired type if you want to retrieve
	  * some information from it.
	  */
        QWidget *subPanel1() const;
	/**
	  * Returns the second subpanel.
	  */
	QWidget *subPanel2() const;
	/**
	  * Use it as a parent widget when creating subpanels.
	  */
	QWidget *subPanelPlace1() const;
	/**
	  * Use it as a parent widget when creating subpanels.
	  */
	QWidget *subPanelPlace2() const;
	/**
	  * True if Apply clicked, False otherwise.
	  */
        //bool result() const { return m_result; }
  /*
  signals:
	
          * Apply or Cancel clicked. See result()

        void acceptValue();
  */
  protected:
	QWidget *m_subpanel_1;
	QWidget *m_subpanel_2;
        //bool m_result;
  /*
  private slots:
        void apply_clicked();
        void cancel_clicked();
  */
};

//-------------------------------------------------------------//

class QLabel;
class QSpinBox;
class QListBox;
class QGridLayout;
class KSSelectArrow : public QWidget
 {
	Q_OBJECT
  public:
	KSSelectArrow( QWidget *parent );
	virtual ~KSSelectArrow();
	void setPanelArrow( const QSGArrow& p );
	QSGArrow panelArrow() const { return m_arrow; }

  protected slots:
	void changePanelArrow(int);

  protected:
	QGridLayout *m_layout;
	QListBox *m_list;
	QLabel *m_label;
	QSpinBox *m_size;
	QSGArrow m_arrow;
 };

//-------------------------------------------------------------//

class KSSelectColor : public QWidget
 {
	Q_OBJECT
  public:
	KSSelectColor( QWidget *parent );
	virtual ~KSSelectColor();
	void setPanelColor( const QSGColor& p );
	QSGColor panelColor() const;

 private slots:
        void showColorDialog();
        void changePanelColor(int);
        void changePanelAlpha(int);

  protected:
	QGridLayout *m_layout;
	QListBox *m_list;
	QLabel *m_label;
	QSpinBox *m_alpha;
	QPushButton *m_custom;
        unsigned char m_color_alpha;
	QColor m_color;
 };

//-------------------------------------------------------------//

class KSSelectFill : public QWidget
 {
	Q_OBJECT
  public:
	KSSelectFill( QWidget *parent );
	virtual ~KSSelectFill();
	void setPanelFill( const QSGFill& p );
	QSGFill panelFill() const;

 protected slots:
        void changePanelBrush(int);

  protected:
	void setPanelBrush( const QBrush& b );
	QBrush panelBrush() const;

	QGridLayout *m_layout;
	QListBox *m_list;
	QBrush m_brush;
 };

//-------------------------------------------------------------//

class KSSelectFont : public QWidget
 {
	Q_OBJECT
  public:
	KSSelectFont( QWidget *parent );
	virtual ~KSSelectFont();
	void setPanelFont( const QSGFont& p );
	QSGFont panelFont() const;

  protected slots:
        void showFontDialog();
        void changePanelQFont(int);
	
  protected:
        void setPanelQFont( const QFont& f );
	QFont panelQFont() const { return m_font; }
	QFont itemFont(int);
	QFont m_font;

	QGridLayout *m_layout;
	QListBox *m_list;
	QPushButton *m_custom;
	QBrush m_brush;
 };

//-------------------------------------------------------------//

class KSSelectLine : public QWidget
 {
	Q_OBJECT
  public:
	KSSelectLine( QWidget *parent );
	virtual ~KSSelectLine();
	void setPanelLine( const QSGLine& l );
	QSGLine panelLine() const;
	void setPanelLineWidth( int width );
	int panelLineWidth() const { return m_pen_width; }
	
  protected slots:
        void changePanelQPen(int);
        void changePanelLineWidth(int);	

  protected:
	void setPanelQPen( const QPen& p );
	QPen panelQPen() const { return m_pen; }
	QPen m_pen;
	int  m_pen_width;
	QGridLayout *m_layout;
	QListBox *m_list;
	QLabel *m_label;
 	QSpinBox *m_width;
 };

//-------------------------------------------------------------//

class KSSelectPoint : public QWidget
 {
	Q_OBJECT
  public:
	KSSelectPoint( QWidget *parent );
	virtual ~KSSelectPoint();
	void setPanelPoint( const QSGPoint& p );
	QSGPoint panelPoint() const;

  protected slots:
        void changePanelPointShape(int);
	void setPanelPointShape( const QSGPoint& p );
	QSGPoint panelPointShape() const { return m_point; }

  protected:
	QGridLayout *m_layout;
	QListBox *m_list;
	QLabel *m_label;
	QSpinBox *m_size;
	QSGPoint m_point;
 };

#endif
