/* definitions for a looper */

#ifndef __PEAKVIEW_H__
#define __PEAKVIEW_H__

#include <pthread.h>
#include "buffer.h"
#include "speciallist.h"
enum {
        PD_STATUS_NEW,
       	PD_STATUS_DONE,
        PD_STATUS_DEAD, 
        PD_STATUS_LAST
};

typedef struct _peakdata {
	long		start;
	long		end;
	long		pstart;
	long 		pend;
	int		status;
	signed char     *Lmin;
        signed char     *Lmax;
        signed char     *Rmin;
        signed char     *Rmax;
} peakdata_t;

typedef struct _peakview {
	pthread_mutex_t peakviewmutex;
	buffer_info_t 	*buf;
	int		group;
	int		dead;
	long		pixels;
	long		start;
	long 		end;
	float		samplesperpixel;
	speciallist_t*  returnlist;
} peakview_t;

peakdata_t *peakdata_new();
/*void peakdata_delete(peakdata_t *pd);*/
void peakdata_set_status(peakdata_t *pd, int status);

peakview_t* peakview_new(buffer_info_t* buf);
void peakview_delete(peakview_t* view);
void peakview_set_buffer(peakview_t* view,buffer_info_t* buf);

void peakview_lock(peakview_t* view);
void peakview_unlock(peakview_t* view);

void peakview_set_area(peakview_t* view, long start, long end, long pixels);
void peakview_calculate(peakview_t* view, long start, long end);
peakdata_t *peakview_get_next(peakview_t* view);
#endif
