/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "scanprogressdlg.h"
#include <qlabel.h>
#include <qlayout.h>
#include <qframe.h>

ScanProgressDialog::ScanProgressDialog(QWidget *parent): QDialog(parent, 0, false, Qt::WStyle_Customize | Qt::WStyle_NoBorder | Qt::WDestructiveClose)
{
	QHBoxLayout *lay0 = new QHBoxLayout(this);
	lpath = new QLabel(this);
	lpath->setAlignment(Qt::AlignLeft);
	lpath->setTextFormat(Qt::PlainText);
	lpath->setMargin(8);
	lpath->setFixedWidth(420);
	lpath->setFrameStyle(QFrame::WinPanel | QFrame::Raised);
	lpath->setLineWidth(2);
	lpath->setMidLineWidth(2);
	lay0->addWidget(lpath);
}

ScanProgressDialog::~ScanProgressDialog()
{
}
		
void ScanProgressDialog::setCurrentPath(const QString &path)
{
	lpath->setText(path);
}

#include "scanprogressdlg.moc"
