/**************************************************************************/
/*  Klavaro - a flexible touch typing tutor                               */
/*  Copyright (C) 2005 - 2008  Felipe Castro                              */
/*                                                                        */
/*  This program is free software, licensed under the terms of the GNU    */
/*  General Public License as published by the Free Software Foundation,  */
/*  which is also included in this package, in a file named "COPYING".    */
/**************************************************************************/

/**************************************************
 * Contest for fluidness performance
 */

#define MIN_CHARS_TO_LOG 500

/**************************************************
 * Structures
 */
typedef struct USERS
{
	gchar *id;
	gchar *name;
} User;

#define MAX_NAME_LEN 100
typedef struct STATISTICS
{
	gchar lang[2];		// Language code
	gchar genv;		// Graphical environment: 'x' = X; 'w' = Windows
	time_t when;		// Epoch of stats logging
	gint nchars;		// Number of chars typed in the test
	gfloat accur;
	gfloat velo;
	gfloat fluid;
	gfloat score;		// s = f (accur, velo, fluid)
	gint name_len;
	gchar name[MAX_NAME_LEN + 1];
} Statistics;

void top10_init_stats (gboolean locally);

void top10_clean_stat (gint i, gboolean locally);

void top10_insert_stat (Statistics * stat, gint i, gboolean locally);

gboolean top10_compare_insert_stat (Statistics * stat, gboolean locally);

void top10_delete_stat (gint i, gboolean locally);

gfloat top10_calc_score (Statistics * stat);

gboolean top10_validate_stat (Statistics * stat);

gchar *top10_get_score_file (gboolean locally, gint lang);

gboolean top10_read_stats_from_file (gboolean locally, gchar * file);

void top10_read_stats (gboolean locally, gint lang);

void top10_write_stats (gboolean locally, gint lang);

void top10_show_stat (Statistics * stats);

void top10_show_stats (gboolean locally);

gboolean top10_global_update (gpointer data);

gboolean top10_global_publish (gpointer data);

void top10_global_rank (void);

gchar *top10_get_host (gchar * updown);

gchar *top10_get_user (gchar * updown);

gchar *top10_get_pass (gchar * updown);

gboolean top10_keyfile_proverbaro (void);

gboolean top10_host_test (gpointer data);

