/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _SCANVIEWER_H_
#define _SCANVIEWER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>


class KPrinter;
class KToggleAction;
class KURL;
class QLineEdit;
class QComboBox;
class QCheckBox;
class QListBox;
class QListView;
class QListViewItem;
class QPushButton;
class QLabel;
class KProcess;
class KConfig;
class KURLRequester;


/**
 * This class serves as the main window for ScanViewer.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class ScanViewer  : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    ScanViewer(QWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~ScanViewer();

    /**
     * Use this method to load whatever file/URL you have
     */
    
    //void  setDirName(QString);
    void slotScan(const QString & filepattern, int mode, bool recursive);
    void slotCancel();
    void slotStartAgain();
    bool scanGoingOn();

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(KConfig *);


private slots:

private:
    void setupAccel();
    void setupActions();

private:

signals:
    void itemSelected(QString abs_filename, int line);
    void scanFinished(QWidget *);
public slots:


private slots:
    //void dirButtonClicked();
    //void templateActivated(int index);
    void childExited();
    void receivedOutput(KProcess *proc, char *buffer, int buflen);
    //void itemSelected(const QString&);
    void slotClear();
    void slotRMB( QListViewItem *, const QPoint &, int );
    void slotQuarantineSelected();
    void slotVirusPool();
    void slotGoogle();
    void slotTrendMicro();
    //void patternTextChanged( const QString &);
private:
    void processOutput();
    void finish();
    void getout();
    void Quarantine();
    void askUser();
    QLineEdit *template_edit;
    QComboBox *files_combo, *pattern_combo, *check_combo;
    //KComboBox *dir_combo;
    QCheckBox *recursive_box;
    QCheckBox *recursive_box2;
    QListView *resultview;
    QPushButton *search_button, *cancel_button;
    QLabel *status_label, *status2_label,*matches_label,*matches2_label;
    KProcess *childproc;
    QString buf;
    KConfig* config;
    QStringList lastSearchItems;
    QStringList lastScanPaths;
    QStringList lastQuarItems;
    QStringList QuarantineList;
    bool errorsEncountered;
    QPopupMenu* menu;
    QPushButton* adv_options;
    QPushButton* schedule;
    QString selectedVirus;
    bool multiScan;
    QString urlsToScan;
    bool scanInProgress;
    QString prevdir;
    QStringList listOfUrlsToScan;
    bool multi_recursive;
    int m_mode;
    QString m_filepattern;
    bool m_recursive;
    int filesscanned;
};

#endif // _SCANVIEWER_H_
