/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _KUARANTINE_H_
#define _KUARANTINE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>



class KPrinter;
class KToggleAction;
class KURL;
class QLineEdit;
class QComboBox;
class QCheckBox;
class QListView;
class QPushButton;
class QLabel;
class KProcess;
class KConfig;
class KURLRequester;
class QListViewItem;


/**
 * This class serves as the main window for Kuarantine.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Kuarantine :  public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Kuarantine(QWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~Kuarantine();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load();
    void  setDirName(QString);
    void createQuarDir();
    QString getFileName(QString);
    QString getVirusName(QString);
    QString getWhen(QString);
    QString getSelectedVirusName();

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(KConfig *);


private slots:
/*    void fileNew();
    void fileOpen();
    void fileSave();
    void fileSaveAs();
    void filePrint();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();
*/
    //void changeStatusbar(const QString& text);
    //void changeCaption(const QString& text);
    void slotRMB( QListViewItem *, const QPoint &, int );
    //void resizeEvent ( QResizeEvent * );
private:
    void setupAccel();
    void setupActions();

private:
    //KuarantineView *m_view;

  /*  KPrinter   *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;*/


signals:
    void itemSelected(QString abs_filename, int line);

public slots:

    void refresh();
private slots:
    void slotSearch();
    void slotCancel();
    void refreshhistory();
    void slotClearHistory();
    void slotDeleteHistory();
    void updateLastQuarLocations();
    void slotVirusPoolCurrent();
    void slotGoogleCurrent();
    void slotTrendMicroCurrent();
    void slotVirusPoolHistory();
    void slotGoogleHistory();
    void slotTrendMicroHistory();

    //void patternTextChanged( const QString &);
private:
    void getout();

    QLineEdit *template_edit;
    QComboBox *files_combo, *pattern_combo/*, *dir_combo*/;
    KURLRequester *dir_combo;
    QCheckBox *recursive_box;
    QListView *currentbox;
    QListView *historybox;
    QPushButton *search_button, *cancel_button, *refresh_button, *search_button3, *cancel_button3;
    QLabel *status_label, *matches_label;
    KProcess *childproc;
    QString buf;
    KConfig* config;
    QStringList lastQuarItems;
    QStringList lastHistoryItems;
    QStringList lastQuarLocations;
    QStringList lastSearchPaths;
    QString quarloc;
    QPopupMenu* qmenu;
    QPopupMenu* hmenu;

};

#endif // _Kuarantine_H_
