/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _KLAMD_H_
#define _KLAMD_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include <qlistview.h>
#include <qlistbox.h>
#include "kfiletreeview.h"



class KPrinter;
class KToggleAction;
class KURL;
class QLineEdit;
class QComboBox;
class QCheckBox;
class QListBox;
class QPushButton;
class QLabel;
class KProcess;
class KConfig;
class KURLRequester;
class K3bFileTreeView;
class KArrowButton;
class KProcIO;
class KSystemTray;

class MyListBox : public QListBox
{

public:
	MyListBox(QWidget *parent) : QListBox(parent) {}
	bool isItemVisible(int id) { return itemVisible(id); }
};

/**
 * This class serves as the main window for Klamd.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Klamd :  public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Klamd(QWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~Klamd();

    /**
     * Use this method to load whatever file/URL you have
     */
    void  setDirName(QString);
    bool isKlamdAlive();
    QString  getKlamdConfFile();
    
public slots:
    bool startKlamd();
    void slotCancel();
    
protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(KConfig *);


public:
private:
    void setupAccel();
    void setupActions();

private:
    //KlamdView *m_view;

  /*  KPrinter   *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;*/


signals:
    void itemSelected(QString abs_filename, int line);



private slots:
    //void dirButtonClicked();
    //void templateActivated(int index);
    void childExited();
    void receivedOutput(KProcIO *);
    //void itemSelected(const QString&);
    void slotClear();
    void slotAddIncludeDir();
    void slotAddExcludeDir();
    void slotDelIncludeDir();
    void slotDelExcludeDir();
    void writeConf();
    void Quarantine(QString fname, QString virusname);
    void restoreKlamd();
    void handleChecks();
    void checkForDazuko();
    void loadDazuko();
    void lsmodOutput();
    void lsmodCheck();
    void moduleLoaded();
    void receivedmvOutput(KProcIO *);
    void slotAdvOptions();

    //void patternTextChanged( const QString &);
private:
    void processOutput();
    void finish();
    void getout();
    int runDazuko(bool caller);
    void loadKlamd();
    void enableInputs();
    void disableInputs();
    QLineEdit *template_edit;
    QComboBox *files_combo, *pattern_combo/*, *dir_combo*/;
    KURLRequester *dir_combo;
    QCheckBox *recursive_box;
    QCheckBox *recursive_box1;
    QCheckBox *recursive_box2;
    QListBox *resultbox;
    QLabel *status_label, *matches_label;
    KProcIO *childproc;
    KProcIO *proc; 
    KProcIO *lsmodproc;
    QString buf, bufmv, mvbuffer;
    KConfig* config;
    QStringList lastSearchItems;
    QStringList lastSearchPaths;
    QStringList lastQuarItems;
    QListView* table;
    MyListBox	*sessionslb;
    KArrowButton    *btnup, *btndown;
    KFileTreeView* m_fileTreeView;
    KFileTreeBranch* treeBranch;
    MyListBox	*sessionslb2;
    KArrowButton    *btnup2, *btndown2;
    KFileTreeView* m_fileTreeView2;
    KFileTreeBranch* treeBranch2;
    QString tempFileName;
    QComboBox *check_combo;
    QComboBox *check_combo2;
    QString item2;
    QStringList includePaths;
    QStringList excludePaths;
    bool dazukoLoaded;
    bool klamdAlive;
    QWidget *parent;
    QString tmpit;
    QString clamdcommand;
    QPushButton *adv_options;
    QWidget *hlp;
    QWidget *hlp2;
    QWidget *hlp3;
public:
    QPushButton *search_button, *cancel_button;


};

#endif // _Klamd_H_
