/*
   This file is part of libkdepim.
   Copyright (c) 2004 Daniel Molkentin <molkentin@kde.org>
   based on code by Cornelius Schumacher <schumacher@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/


#include "clicklineedit.h"
#include "klamscan.h"
#include "klamav.h"

#include "qpainter.h"

ClickComboBox::ClickComboBox(   bool   rw,QWidget *parent, const char* name ) :
        KComboBox( rw,parent, name )
{
/*    mDrawClickMsg = true;
    setClickMessage( msg );*/
}


/////////////////////////////////////////////////////////////////////////////////////
// PUBLIC
/////////////////////////////////////////////////////////////////////////////////////

// void ClickComboBox::setClickMessage( const QString &msg )
// {
//     mClickMessage = msg;
//     repaint();
// }


void ClickComboBox::mousePressEvent( QMouseEvent * e )
{

    QComboBox::mousePressEvent( e );
    repaint();

}


/////////////////////////////////////////////////////////////////////////////////////
// PROTECTED
/////////////////////////////////////////////////////////////////////////////////////

void ClickComboBox::paintEvent( QPaintEvent * ev)
{

	KComboBox::paintEvent(ev);

   	if (kmain->klamscan->isMultiScan()){
		//kdDebug() << "drawing text" << endl;
		QPainter p (this->lineEdit());
		p.setPen( palette().color( QPalette::Disabled, QColorGroup::Text ) );
		QRect cr = this->lineEdit()->contentsRect();
	//        Add two pixel margin on the left side
		//cr.setRight( cr.right() + 800 );
		cr.setWidth(800);
		//kdDebug() << cr << endl;
		p.drawText( cr, AlignAuto , "Multiple Directories Selected" );
		//this->setPaletteForegroundColor(palette().color( QPalette::Disabled, QColorGroup::Text ));
	}
}


void ClickComboBox::focusInEvent( QFocusEvent *ev )
{
/*    if ( mDrawClickMsg == true ) {
        mDrawClickMsg = false;
        repaint();
    }*/
    QComboBox::focusInEvent( ev );
}


void ClickComboBox::focusOutEvent( QFocusEvent *ev )
{
/*    if ( currentText().isEmpty() ) {
        mDrawClickMsg = true;
        repaint();
    }*/
    QComboBox::focusOutEvent( ev );
}

