/***************************************************************************
                          imagemapdialog.h  -  description
                             -------------------
    begin                : Wed Apr 4 2001
    copyright            : (C) 2001 by Jan Schfer
    email                : janschaefer@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KIMAGEMAPDIALOG_H
#define KIMAGEMAPDIALOG_H

#include <kmainwindow.h>
#include <qlist.h>
#include <qdict.h>
#include <kurl.h>

#include "kdeversion.h"

#include "kimearea.h"

/**
  *@author Jan Schfer
  */

#define VERSION "0.9.5.1"

class QListView;
class QPushButton;
class DrawZone;
class QComboBox;
class QListViewItem;
class KToggleAction;


/**
 * Stores an area tag and all its attributes
 */
typedef QDict<QString> AreaTag;

/**
 * Stores an image tag and all its attributes
 */
typedef QDict<QString> ImageTag;

/**
 * Only a small class to give a list of AreaTags a name
 */
class MapTag : public QList<AreaTag> {
	public:
		QString name;
};

class KSelectAction;
class KRadioAction;
class KRecentFilesAction;
class KAction;
class KAccel;
///class QListViewItem;
class QPopupMenu;
class KCommandHistory;
class KApplication;

// needed by the statusbar
#define STATUS_CURSOR 1000
#define STATUS_SELECTION 1001

class KImageMapEditor : public KMainWindow {
Q_OBJECT
public :
   enum ToolType { Selection, Rectangle, Circle, Polygon, Freehand, AddPoint, RemovePoint };

private:
	// the url where the map is stored e.g. a HTML or TXT file
	KURL _mapUrl;	
	// the url of the working image;
	KURL _imageUrl;
	bool modified;
	QString _mapName;
	KImageMapEditor::ToolType _currentToolType;
	AreaList *areas;
	AreaSelection *currentSelected;
	AreaSelection *copyArea;
	Area *defaultArea;
	DrawZone* drawZone;
	QListView* listView;
	KAction* saveAction;
	KRecentFilesAction* recentFilesAction;
	KSelectAction* zoomAction;
	KRadioAction *arrowAction;
	KRadioAction *circleAction;
	KRadioAction *rectangleAction;
	KRadioAction *polygonAction;
	KRadioAction *freehandAction;
	KRadioAction *addPointAction;
	KRadioAction *removePointAction;
	
	KAction *cutAction;
	KAction *deleteAction;
	KAction *copyAction;
	KAction *pasteAction;
	KAction *zoomInAction;
	KAction *zoomOutAction;
	
	KToggleAction *highlightAreasAction;
	KToggleAction *showAltAction;
	
	KAction *areaPropertiesAction;
	
	KAction *moveLeftAction;
	KAction *moveRightAction;
	KAction *moveUpAction;
	KAction *moveDownAction;
	
	KAction *increaseWidthAction;
	KAction *decreaseWidthAction;
	KAction *increaseHeightAction;
	KAction *decreaseHeightAction;
	
	KAction *toFrontAction;
	KAction *toBackAction;
	KAction *forwardOneAction;
	KAction *backOneAction;
	
	KAccel *accel;
	
	QPopupMenu *popupMenu;
	QPushButton *upBtn;
	QPushButton *downBtn;
	KCommandHistory *_commandHistory;
	bool _stdout; // write HTML-Code to stdout on exit ?
	int maxAreaPreviewHeight;
	void setupActions();
	void setupStatusBar();
	void saveImageMap(const KURL & url);
	/* refreshes all Areas, only used by preferences dialog
	 * updates only the preview pictures*/
	void updateAllAreas();	
	void deleteAllAreas();
	void updateUpDownBtn();
	
	QDict<QString> getTagAttributes(QTextStream & s);
	
protected:
  virtual void saveProperties(KConfig *);
  virtual void readProperties(KConfig *);
  virtual bool queryClose();
//  virtual bool queryExit();
public:
	KImageMapEditor(QWidget* parent=0);
	~KImageMapEditor();
	
	/**
	 * Makes sure, that the actions cut, copy, delete and
	 * show properties
	 * can only be executed if sth. is selected.
	 **/
	void updateActionAccess();
	
  DrawZone* getDrawZone() { return drawZone; };

	void addAreaAndEdit(Area*);
	void addArea(Area*);
	AreaListIterator areaList() const;
	KImageMapEditor::ToolType currentToolType() const;
	void deleteSelected();
	void deleteArea( Area * area);
	void deselectAll();
	void deselect(Area* s);
	void deselectWithoutUpdate(Area* s);
	QString getHTMLImageMap() const;
	Area* onArea(const QPoint & p) const;
	void openHTMLFile(const KURL & url);
	QPixmap makeListViewPix(Area & a) ;
	QString mapName() const;
	void select(Area* s);
	void selectWithoutUpdate(Area* s);
	void select(QListViewItem*);	
	AreaSelection* selected() const;
	void setPicture(const KURL & url);
	void setPicture(const QImage & pix);
	void setStdout(bool b);
	void setUrl(const KURL & s);
	int showTagEditor(Area *a);
	void setMapName(const QString & s);
	KURL url() const;
	KCommandHistory *commandHistory() const;
	
	KApplication* app() const;
	
	// Only refreshes the listView
	void updateSelection() const;
public slots:
	void slotChangeStatusCoords(int x,int y);
	void slotUpdateSelectionCoords();
	void slotUpdateSelectionCoords( const QRect & r );
	void slotAreaChanged(Area *);
	void slotOpenFile(const KURL & url);
	void slotShowPopupMenu(const QPoint & pos);
protected slots:
	void slotShowPopupMenu(QListViewItem*,const QPoint &);
	void slotShowPreferences();
	void slotHightlightAreas();
	void slotShowAltTag();
	void slotSelectionChanged();

	int showTagEditor(QListViewItem *item);
	int showTagEditor();
	void slotConfigChanged();
	void slotOpenFile();
	void slotSaveFile();
	void slotSaveFileAs();
	void slotCloseFile();
  void slotZoom();
  void slotZoomIn();
  void slotZoomOut();
  void slotDelete();
  void slotDrawArrow();
  void slotDrawCircle();
  void slotDrawRectangle();
  void slotDrawPolygon();
  void slotDrawFreehand();
  void slotDrawAddPoint();
  void slotDrawRemovePoint();
  void slotEditDefaultArea();
  void slotEditMapName();
  void slotShowHTML();
	void slotCut();
	void slotCopy();
	void slotPaste();
  void slotEditKeys();
	void slotEditToolbars();
	void slotToggleToolbar();
	void slotToggleStatusbar();
	
	void slotBackOne();
	void slotForwardOne();
	void slotToBack();
	void slotToFront();
	
	void slotMoveUp();
	void slotMoveDown();
	void slotMoveLeft();
	void slotMoveRight();
	
	void slotIncreaseHeight();
	void slotDecreaseHeight();
	void slotIncreaseWidth();
	void slotDecreaseWidth();
	
	void slotCancelDrawing();

//	void slotPreferences();


};


inline KImageMapEditor::ToolType KImageMapEditor::currentToolType() const {
	return _currentToolType;
}

inline QString KImageMapEditor::mapName() const {
	return _mapName;
}

inline KCommandHistory* KImageMapEditor::commandHistory() const {
	return _commandHistory;
}

inline void KImageMapEditor::setMapName(const QString & s) {
	_mapName=s;
}

inline KURL KImageMapEditor::url() const {
	return _mapUrl;
}

inline void KImageMapEditor::setUrl(const KURL & url) {
	_mapUrl=url;
}

inline void KImageMapEditor::setStdout(bool b) {
	_stdout=b;
}

#endif
