/* $Id: log.c,v 1.11 2005/11/03 19:42:42 ekalin Exp $ */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <libintl.h>
#include <locale.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include "kildclient.h"
#include "perlscript.h"


/*************************
 * File global variables *
 *************************/


/***************************
 * Telnet protocol defines *
 ***************************/


/***********************
 * Function prototypes *
 ***********************/



void
write_log_line(World *world, const char *line)
{
  int         len;
  static char timestr[MAX_TIME_STR];

  if (world->log_timeformat) {
    time_t     currtime;
    struct tm *brokentime;

    currtime = time(NULL);
    brokentime = localtime(&currtime);
    strftime(timestr, MAX_TIME_STR,
             world->log_timeformat,
             brokentime);

    fprintf(world->log_file, "%s", timestr);
  }

  len = strlen(line);
  if (!len) {
    return;
  }

  fputs(line, world->log_file);

  /* Finish always with a NL character */
  if (line[len - 1] != '\n') {
    fputc('\n', world->log_file);
  }
}


char *
close_log_file(World *world, int keep_timeformat)
{
  /* Returns the formatted time string, but this is only valid until
     the next call. */

  time_t      curr_time;
  static char timestr[MAX_TIME_STR];

  time(&curr_time);
  strcpy(timestr, ctime(&curr_time));
  /* Remove final nl */
  timestr[strlen(timestr) - 1] = '\0';
  if (world->log_file) {
    fprintf(world->log_file, "\n*** LOG ENDED AT %s ***\n\n",
            timestr);
    fclose(world->log_file);
    world->log_file = NULL;
    g_free(world->log_file_name);

    if (!keep_timeformat) {
      g_free(world->log_timeformat);
      world->log_timeformat = NULL;
    }
  }

  return timestr;
}
