/////////////////////////////////////////////////////////////////////////////
// Name:        setpage.cpp
// Purpose:     
// Author:      jean-pierre Charras
// Modified by: 
// Created:     06/02/2006 20:53:09
// RCS-ID:      
// Copyright:   License GNU
// Licence:     
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), 06/02/2006 20:53:09

#if defined(__GNUG__) && !defined(NO_GCC_PRAGMA)
#pragma implementation "setpage.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes
#include "fctsys.h"
#include "gr_basic.h"

#include "common.h"

#ifdef EESCHEMA
#include "program.h"
#include "general.h"
#endif

#define NB_ITEMS 11
Ki_PageDescr * SheetList[NB_ITEMS+1] =
{
	&g_Sheet_A4, &g_Sheet_A3, &g_Sheet_A2, &g_Sheet_A1, &g_Sheet_A0,
	&g_Sheet_A, &g_Sheet_B, &g_Sheet_C, &g_Sheet_D, &g_Sheet_E,
	&g_Sheet_user, NULL
};

#include "setpage.h"

////@begin XPM images
////@end XPM images

/******************************************************************/
void WinEDA_DrawFrame::Process_PageSettings(wxCommandEvent& event)
/******************************************************************/
/* Creation de la fenetre de configuration
*/
{
	WinEDA_SetPageFrame frame(this);
	frame.ShowModal();
	ReDrawPanel();
}

/*!
 * WinEDA_SetPageFrame type definition
 */

IMPLEMENT_DYNAMIC_CLASS( WinEDA_SetPageFrame, wxDialog )

/*!
 * WinEDA_SetPageFrame event table definition
 */

BEGIN_EVENT_TABLE( WinEDA_SetPageFrame, wxDialog )

////@begin WinEDA_SetPageFrame event table entries
    EVT_CLOSE( WinEDA_SetPageFrame::OnCloseWindow )

    EVT_BUTTON( wxID_OK, WinEDA_SetPageFrame::OnOkClick )

    EVT_BUTTON( wxID_CANCEL, WinEDA_SetPageFrame::OnCancelClick )

////@end WinEDA_SetPageFrame event table entries

END_EVENT_TABLE()

/*!
 * WinEDA_SetPageFrame constructors
 */

WinEDA_SetPageFrame::WinEDA_SetPageFrame( )
{
}

WinEDA_SetPageFrame::WinEDA_SetPageFrame( WinEDA_DrawFrame* parent, wxWindowID id,
				const wxString& caption, const wxPoint& pos,
				const wxSize& size, long style )
{
wxString msg;
	
	m_ParentDrawFrame = parent;
	m_Screen = m_ParentDrawFrame->m_CurrentScreen;
	m_Modified = FALSE;
	m_SelectedSheet = NULL;
    m_CurrentSelection = 0;
	SearchPageSizeSelection();
    Create(parent, id, caption, pos, size, style);
	// Init display value for sheet User size
	wxString format = m_TextSheetCount->GetLabel();
	msg.Printf(format, m_Screen->m_NumberOfSheet);
	m_TextSheetCount->SetLabel(msg);
	format = m_TextSheetNumber->GetLabel();
	msg.Printf(format, m_Screen->m_SheetNumber);
	m_TextSheetNumber->SetLabel(msg);
	if ( g_UnitMetric )
	{
		UserSizeX = (double)g_Sheet_user.m_Size.x * 25.4 / 1000 ;
		UserSizeY = (double)g_Sheet_user.m_Size.y * 25.4 / 1000;
		msg.Printf( wxT("%.2f"), UserSizeX);
		m_TextUserSizeX->SetValue(msg);
		msg.Printf( wxT("%.2f"), UserSizeY);
		m_TextUserSizeY->SetValue(msg);
	}
	else
	{
		UserSizeX = (double)g_Sheet_user.m_Size.x / 1000;
		UserSizeY = (double)g_Sheet_user.m_Size.y / 1000;
		msg.Printf( wxT("%.3f"), UserSizeX );
		m_TextUserSizeX->SetValue(msg);
		msg.Printf( wxT("%.3f"), UserSizeY );
		m_TextUserSizeY->SetValue(msg);
	}
}

/*!
 * WinEDA_SetPageFrame creator
 */

bool WinEDA_SetPageFrame::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin WinEDA_SetPageFrame member initialisation
    m_PageSizeBox = NULL;
    m_TextUserSizeX = NULL;
    m_TextUserSizeY = NULL;
    m_TextSheetCount = NULL;
    m_TextSheetNumber = NULL;
    m_RevisionSizer = NULL;
    m_TextRevision = NULL;
    m_NameSizer = NULL;
    m_TextTitle = NULL;
    m_CompanySizer = NULL;
    m_TextCompany = NULL;
    m_Comment1Sizer = NULL;
    m_TextComment1 = NULL;
    m_Comment2Sizer = NULL;
    m_TextComment2 = NULL;
    m_Comment3Sizer = NULL;
    m_TextComment3 = NULL;
    m_Comment4Sizer = NULL;
    m_TextComment4 = NULL;
////@end WinEDA_SetPageFrame member initialisation

////@begin WinEDA_SetPageFrame creation
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if (GetSizer())
    {
        GetSizer()->SetSizeHints(this);
    }
    Centre();
////@end WinEDA_SetPageFrame creation
    return true;
}

/*!
 * Control creation for WinEDA_SetPageFrame
 */

void WinEDA_SetPageFrame::CreateControls()
{    
	SetFont(*g_DialogFont);
	
////@begin WinEDA_SetPageFrame content construction
    // Generated by DialogBlocks, 11/01/2007 11:38:01 (unregistered)

    WinEDA_SetPageFrame* itemDialog1 = this;

    this->SetForegroundColour(wxColour(0, 128, 64));
    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer3, 0, wxGROW|wxALL, 5);

    wxString m_PageSizeBoxStrings[] = {
        _("Size A4"),
        _("Size A3"),
        _("Size A2"),
        _("Size A1"),
        _("Size A0"),
        _("Size A"),
        _("Size B"),
        _("Size C"),
        _("Size D"),
        _("Size E"),
        _("User size")
    };
    m_PageSizeBox = new wxRadioBox( itemDialog1, ID_RADIOBOX, _("Page Size:"), wxDefaultPosition, wxDefaultSize, 11, m_PageSizeBoxStrings, 1, wxRA_SPECIFY_COLS );
    m_PageSizeBox->SetSelection(0);
    itemBoxSizer3->Add(m_PageSizeBox, 0, wxGROW|wxALL, 5);

    wxStaticText* itemStaticText5 = new wxStaticText( itemDialog1, wxID_STATIC, _("User Page Size X: "), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(itemStaticText5, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextUserSizeX = new wxTextCtrl( itemDialog1, ID_TEXTCTRL7, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(m_TextUserSizeX, 0, wxALIGN_LEFT|wxALL, 5);

    wxStaticText* itemStaticText7 = new wxStaticText( itemDialog1, wxID_STATIC, _("User Page Size Y: "), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(itemStaticText7, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextUserSizeY = new wxTextCtrl( itemDialog1, ID_TEXTCTRL8, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(m_TextUserSizeY, 0, wxALIGN_LEFT|wxALL, 5);

    wxBoxSizer* itemBoxSizer9 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer9, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer10 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer9->Add(itemBoxSizer10, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    wxButton* itemButton11 = new wxButton( itemDialog1, wxID_OK, _("&OK"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton11->SetDefault();
    itemButton11->SetForegroundColour(wxColour(200, 0, 0));
    itemBoxSizer10->Add(itemButton11, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxButton* itemButton12 = new wxButton( itemDialog1, wxID_CANCEL, _("&Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton12->SetForegroundColour(wxColour(0, 0, 255));
    itemBoxSizer10->Add(itemButton12, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer13 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer9->Add(itemBoxSizer13, 0, wxGROW|wxALL, 5);

    m_TextSheetCount = new wxStaticText( itemDialog1, wxID_STATIC, _("Number of sheets: %d"), wxDefaultPosition, wxDefaultSize, 0 );
    m_TextSheetCount->SetForegroundColour(wxColour(128, 0, 128));
    itemBoxSizer13->Add(m_TextSheetCount, 0, wxGROW|wxALL|wxADJUST_MINSIZE, 5);

    itemBoxSizer13->Add(5, 5, 0, wxGROW|wxALL, 5);

    m_TextSheetNumber = new wxStaticText( itemDialog1, wxID_STATIC, _("Sheet number: %d"), wxDefaultPosition, wxDefaultSize, 0 );
    m_TextSheetNumber->SetForegroundColour(wxColour(128, 0, 128));
    itemBoxSizer13->Add(m_TextSheetNumber, 0, wxGROW|wxALL|wxADJUST_MINSIZE, 5);

    wxStaticBox* itemStaticBoxSizer17Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Revision:"));
    m_RevisionSizer = new wxStaticBoxSizer(itemStaticBoxSizer17Static, wxHORIZONTAL);
    itemStaticBoxSizer17Static->SetForegroundColour(wxColour(200, 0, 0));
    itemBoxSizer9->Add(m_RevisionSizer, 0, wxGROW, 5);

    m_TextRevision = new wxTextCtrl( itemDialog1, ID_TEXTCTRL, _T(""), wxDefaultPosition, wxSize(100, -1), wxTE_RICH );
    m_RevisionSizer->Add(m_TextRevision, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticBox* itemStaticBoxSizer19Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Title:"));
    m_NameSizer = new wxStaticBoxSizer(itemStaticBoxSizer19Static, wxHORIZONTAL);
    itemStaticBoxSizer19Static->SetForegroundColour(wxColour(200, 0, 0));
    itemBoxSizer9->Add(m_NameSizer, 0, wxALIGN_CENTER_HORIZONTAL, 5);

    m_TextTitle = new wxTextCtrl( itemDialog1, ID_TEXTCTRL2, _T(""), wxDefaultPosition, wxSize(400, -1), 0 );
    m_NameSizer->Add(m_TextTitle, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer21Static = new wxStaticBox(itemDialog1, wxID_ANY, _("Company:"));
    m_CompanySizer = new wxStaticBoxSizer(itemStaticBoxSizer21Static, wxHORIZONTAL);
    itemStaticBoxSizer21Static->SetForegroundColour(wxColour(200, 0, 0));
    itemBoxSizer9->Add(m_CompanySizer, 0, wxGROW, 5);

    m_TextCompany = new wxTextCtrl( itemDialog1, ID_TEXTCTRL1, _T(""), wxDefaultPosition, wxSize(400, -1), 0 );
    m_CompanySizer->Add(m_TextCompany, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer23Static = new wxStaticBox(itemDialog1, wxID_STATIC, _("Comment1:"));
    m_Comment1Sizer = new wxStaticBoxSizer(itemStaticBoxSizer23Static, wxHORIZONTAL);
    itemStaticBoxSizer23Static->SetForegroundColour(wxColour(196, 0, 100));
    itemBoxSizer9->Add(m_Comment1Sizer, 0, wxGROW|wxADJUST_MINSIZE, 5);

    m_TextComment1 = new wxTextCtrl( itemDialog1, ID_TEXTCTRL3, _T(""), wxDefaultPosition, wxSize(400, -1), 0 );
    m_Comment1Sizer->Add(m_TextComment1, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticBox* itemStaticBoxSizer25Static = new wxStaticBox(itemDialog1, wxID_STATIC, _("Comment2:"));
    m_Comment2Sizer = new wxStaticBoxSizer(itemStaticBoxSizer25Static, wxHORIZONTAL);
    itemStaticBoxSizer25Static->SetForegroundColour(wxColour(196, 0, 100));
    itemBoxSizer9->Add(m_Comment2Sizer, 0, wxGROW|wxADJUST_MINSIZE, 5);

    m_TextComment2 = new wxTextCtrl( itemDialog1, ID_TEXTCTRL4, _T(""), wxDefaultPosition, wxSize(400, -1), 0 );
    m_Comment2Sizer->Add(m_TextComment2, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticBox* itemStaticBoxSizer27Static = new wxStaticBox(itemDialog1, wxID_STATIC, _("Comment3:"));
    m_Comment3Sizer = new wxStaticBoxSizer(itemStaticBoxSizer27Static, wxHORIZONTAL);
    itemStaticBoxSizer27Static->SetForegroundColour(wxColour(196, 0, 100));
    itemBoxSizer9->Add(m_Comment3Sizer, 0, wxGROW|wxADJUST_MINSIZE, 5);

    m_TextComment3 = new wxTextCtrl( itemDialog1, ID_TEXTCTRL5, _T(""), wxDefaultPosition, wxSize(400, -1), 0 );
    m_Comment3Sizer->Add(m_TextComment3, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticBox* itemStaticBoxSizer29Static = new wxStaticBox(itemDialog1, wxID_STATIC, _("Comment4:"));
    m_Comment4Sizer = new wxStaticBoxSizer(itemStaticBoxSizer29Static, wxHORIZONTAL);
    itemStaticBoxSizer29Static->SetForegroundColour(wxColour(196, 0, 100));
    itemBoxSizer9->Add(m_Comment4Sizer, 0, wxGROW|wxADJUST_MINSIZE, 5);

    m_TextComment4 = new wxTextCtrl( itemDialog1, ID_TEXTCTRL6, _T(""), wxDefaultPosition, wxSize(400, -1), 0 );
    m_Comment4Sizer->Add(m_TextComment4, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    // Set validators
    m_PageSizeBox->SetValidator( wxGenericValidator(& m_CurrentSelection) );
    m_TextRevision->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Revision) );
    m_TextTitle->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Title) );
    m_TextCompany->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Company) );
    m_TextComment1->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Commentaire1) );
    m_TextComment2->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Commentaire2) );
    m_TextComment3->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Commentaire3) );
    m_TextComment4->SetValidator( wxTextValidator(wxFILTER_NONE, & m_Screen->m_Commentaire4) );
////@end WinEDA_SetPageFrame content construction

#ifdef EESCHEMA
    m_RevisionExport = new wxCheckBox(this, -1,_("Export to other sheets"));
    m_RevisionSizer->Add(m_RevisionExport, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxBOTTOM, 5);
    m_TitleExport = new wxCheckBox(this, -1,_("Export to other sheets"));
    m_NameSizer->Add(m_TitleExport, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxBOTTOM, 5);
    m_CompanyExport = new wxCheckBox(this, -1,_("Export to other sheets"));
    m_CompanySizer->Add(m_CompanyExport, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxBOTTOM, 5);
    m_Comment1Export = new wxCheckBox(this, -1,_("Export to other sheets"));
    m_Comment1Sizer->Add(m_Comment1Export, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxBOTTOM, 5);
    m_Comment2Export = new wxCheckBox(this, -1,_("Export to other sheets"));
    m_Comment2Sizer->Add(m_Comment2Export, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxBOTTOM, 5);
    m_Comment3Export = new wxCheckBox(this, -1,_("Export to other sheets"));
    m_Comment3Sizer->Add(m_Comment3Export, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxBOTTOM, 5);
    m_Comment4Export = new wxCheckBox(this, -1,_("Export to other sheets"));
    m_Comment4Sizer->Add(m_Comment4Export, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxBOTTOM, 5);
#else
	m_RevisionExport = NULL;
	m_TitleExport = NULL;
	m_CompanyExport = NULL;
	m_Comment1Export = NULL;
	m_Comment2Export = NULL;
	m_Comment3Export = NULL;
	m_Comment4Export = NULL;
#endif
}

/*!
 * Should we show tooltips?
 */

bool WinEDA_SetPageFrame::ShowToolTips()
{
    return true;
}

/*!
 * Get bitmap resources
 */

wxBitmap WinEDA_SetPageFrame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin WinEDA_SetPageFrame bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end WinEDA_SetPageFrame bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon WinEDA_SetPageFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin WinEDA_SetPageFrame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end WinEDA_SetPageFrame icon retrieval
}
/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
 */

void WinEDA_SetPageFrame::OnOkClick( wxCommandEvent& event )
{
	SavePageSettings(event);
	Close(TRUE);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void WinEDA_SetPageFrame::OnCancelClick( wxCommandEvent& event )
{
	Close(TRUE);
}


/*****************************************************************/
void WinEDA_SetPageFrame::SavePageSettings(wxCommandEvent& event)
/*****************************************************************/
/* Mise a jour effective des textes et dimensions
*/
{
double dtmp;
wxString msg;
	
	m_Screen->m_Revision = m_TextRevision->GetValue();
	m_Screen->m_Company = m_TextCompany->GetValue();
	m_Screen->m_Title = m_TextTitle->GetValue();
	m_Screen->m_Commentaire1 = m_TextComment1->GetValue();
	m_Screen->m_Commentaire2 = m_TextComment2->GetValue();
	m_Screen->m_Commentaire3 = m_TextComment3->GetValue();
	m_Screen->m_Commentaire4 = m_TextComment4->GetValue();

	msg = m_TextUserSizeX->GetValue();
	msg.ToDouble(&dtmp); UserSizeX = dtmp;
	msg = m_TextUserSizeY->GetValue();
	msg.ToDouble(&dtmp); UserSizeY = dtmp;

	int ii = m_PageSizeBox->GetSelection();
	if ( ii < 0 ) ii = 0;
	m_SelectedSheet = SheetList[ii];
	m_Screen->m_CurrentSheet = m_SelectedSheet;

	if ( g_UnitMetric )
	{
		g_Sheet_user.m_Size.x = (int)(UserSizeX * 1000 / 25.4 );
		g_Sheet_user.m_Size.y = (int)(UserSizeY * 1000 / 25.4 );
	}
	else
	{
		g_Sheet_user.m_Size.x = (int)(UserSizeX * 1000 );
		g_Sheet_user.m_Size.y = (int)(UserSizeY * 1000 );
	}

	if ( g_Sheet_user.m_Size.x < 6000 )g_Sheet_user.m_Size.x = 6000;
	if ( g_Sheet_user.m_Size.x > 44000 )g_Sheet_user.m_Size.x = 44000;
	if ( g_Sheet_user.m_Size.y < 4000 )g_Sheet_user.m_Size.y = 4000;
	if ( g_Sheet_user.m_Size.y > 44000 )g_Sheet_user.m_Size.y = 44000;

#ifdef EESCHEMA
	/* Exports settings to other sheets if requested: */
	SCH_SCREEN * screen;
	/* Build the screen list */
	EDA_ScreenList ScreenList(NULL);
	/* Update the datas */
	for ( screen = ScreenList.GetFirst(); screen != NULL; screen = ScreenList.GetNext() )
	{
		if (screen == m_Screen ) continue;
		if ( m_RevisionExport->IsChecked() ) screen->m_Revision = m_Screen->m_Revision;
		if ( m_TitleExport->IsChecked() ) screen->m_Title =m_Screen->m_Title; 
		if ( m_CompanyExport->IsChecked() ) screen->m_Company = m_Screen->m_Company;
		if ( m_Comment1Export->IsChecked() ) screen->m_Commentaire1 = m_Screen->m_Commentaire1;
		if ( m_Comment2Export->IsChecked() ) screen->m_Commentaire2 = m_Screen->m_Commentaire2;
		if ( m_Comment3Export->IsChecked() ) screen->m_Commentaire3 = m_Screen->m_Commentaire3;
		if ( m_Comment4Export->IsChecked() ) screen->m_Commentaire4 = m_Screen->m_Commentaire4;
	}
	
#endif

	m_Screen->SetModify();
	m_Screen->SetRefreshReq();
}



/*******************************************************/
void WinEDA_SetPageFrame::SearchPageSizeSelection(void)
/*******************************************************/
/* Search the correct index to activate the radiobox list size selection
	according to the current page size
*/
{
Ki_PageDescr * sheet;
int ii;
	
	m_CurrentSelection = NB_ITEMS-1;
	for( ii = 0; ii < NB_ITEMS; ii++ )
	{
		sheet = SheetList[ii];
		if( m_ParentDrawFrame->m_CurrentScreen->m_CurrentSheet == sheet )
			m_CurrentSelection = ii;
	}
}

/*!
 * wxEVT_CLOSE_WINDOW event handler for ID_DIALOG
 */

void WinEDA_SetPageFrame::OnCloseWindow( wxCloseEvent& event )
{
	EndModal(m_Modified);
}


