/***************************************************************************
 *   Copyright (C) 2008 by Marcel Hasler                                   *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "wallet.h"

#include <iostream>
using namespace std;

Wallet::Wallet()
{
	m_firstTimeOpen = true;
	m_wallet = 0;
}


Wallet::~Wallet()
{
}


void Wallet::slotWalletClosed()
{
	if (m_wallet)
	{
		delete m_wallet;
		m_wallet = 0;
	}
}


// Private helpers
void Wallet::writePassword(const QString& password)
{
	if (m_firstTimeOpen)
	{
		if (KWallet::Wallet::isOpen(KWallet::Wallet::NetworkWallet()))
			KWallet::Wallet::disconnectApplication(KWallet::Wallet::NetworkWallet(), "kgmailnotifier");

		m_firstTimeOpen = false;
	}

	if (!m_wallet)
		m_wallet = KWallet::Wallet::openWallet(KWallet::Wallet::NetworkWallet());

	if (m_wallet)
	{
		connect(m_wallet, SIGNAL(walletClosed()), this, SLOT(slotWalletClosed()));

		if (!m_wallet->hasFolder("KGmailNotifier"))
			m_wallet->createFolder("KGmailNotifier");

		if (m_wallet->setFolder("KGmailNotifier"))
			m_wallet->writePassword("Password", password);

		KWallet::Wallet::closeWallet(KWallet::Wallet::NetworkWallet(), false);
	}
	else
		cout << "In Wallet::writePassword(): Error: Couldn't connect to KWallet!" << endl;
}


QString Wallet::readPassword()
{
	if (m_firstTimeOpen)
	{
		if (KWallet::Wallet::isOpen(KWallet::Wallet::NetworkWallet()))
			KWallet::Wallet::disconnectApplication(KWallet::Wallet::NetworkWallet(), "kgmailnotifier");

		m_firstTimeOpen = false;
	}

	QString password;

	if (!m_wallet)
		m_wallet = KWallet::Wallet::openWallet(KWallet::Wallet::NetworkWallet());

	if (m_wallet)
	{
		connect(m_wallet, SIGNAL(walletClosed()), this, SLOT(slotWalletClosed()));

		if (m_wallet->setFolder("KGmailNotifier"))
			m_wallet->readPassword("Password", password);
		else
			password = "";

		KWallet::Wallet::closeWallet(KWallet::Wallet::NetworkWallet(), false);

		return password;
	}
	else
	{
		cout << "In Wallet::readPassword(): Error: Couldn't connect to KWallet!" << endl;
		return QString("");
	}
}


void Wallet::deletePassword()
{
	if (!m_wallet)
		m_wallet = KWallet::Wallet::openWallet(KWallet::Wallet::NetworkWallet());

	if (m_wallet)
	{
		connect(m_wallet, SIGNAL(walletClosed()), this, SLOT(slotWalletClosed()));

		if (m_wallet->hasFolder("KGmailNotifier"))
			m_wallet->removeFolder("KGmailNotifier");

		KWallet::Wallet::closeWallet(KWallet::Wallet::NetworkWallet(), false);
	}
	else
		 cout << "In Wallet::deletePassword(): Error: Couldn't connect to KWallet!" << endl;
}


#include "wallet.moc"
