/***************************************************************************
 *   Copyright (C) 2007 by Marcel Hasler                                   *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// mysystemtray.cpp - Customized KSystemtray class with redefined mousePressEvent handler

#include "mysystemtray.h"
#include <qpopupmenu.h>

MySystemTray::MySystemTray(QWidget *parent, const char *name)
	: KSystemTray(parent, name)
{
	m_contextMenu = new QPopupMenu(0, name);
}


MySystemTray::~MySystemTray()
{
	if (m_contextMenu)
		delete m_contextMenu;
}


void MySystemTray::mousePressEvent(QMouseEvent *event)
{
	if (event->button() == QMouseEvent::LeftButton)
		emit mouseButtonPressed();
	else if (event->button() == QMouseEvent::RightButton)
		m_contextMenu->popup(event->globalPos());
}


QPopupMenu *MySystemTray::contextMenu() const
{
	return m_contextMenu;
}

#include "mysystemtray.moc"
