/***************************************************************************
 *   Copyright (C) 2007, 2008 by Marcel Hasler                             *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KGMAILNOTIFIER_H_
#define _KGMAILNOTIFIER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "aboutdata.h"
#include "trayicon.h"
#include "configurationdialog.h"
#include "popupwindow.h"
#include "accountmanager.h"
#include "audioplayer.h"
#include "ledhandler.h"

#include <qtimer.h>

#include <kaboutapplication.h>
#include <kuniqueapplication.h>

class KGmailNotifier : public KUniqueApplication
{
    Q_OBJECT
public:
	KGmailNotifier(AboutData *aboutData);
	~KGmailNotifier();

private:
	KGmailNotifier(const KGmailNotifier&);
	KGmailNotifier& operator=(const KGmailNotifier&);

	TrayIcon *m_trayIcon;
	KAboutApplication *m_aboutWindow;
	ConfigurationDialog *m_configWindow;
	PopupWindow *m_popupWindow;
	AccountManager *m_accountManager;
	QTimer *m_checkMailTimer;
	AudioPlayer *m_audioPlayer;
	LEDHandler *m_ledHandler;

	int m_silentNotificationMenuID;

private slots:
	void slotSilentNotificationSelected();
	void slotProcessMailInfo();
	void slotProcessConnectionError(const QString errorType);
	void slotShowPopupWindow();
	void slotCheckNewMail();
	void slotLaunchBrowser();
	void slotApplyConfiguration();
	void slotShowConfigWindow();
	void slotDeleteConfigWindow();
	void slotShowAboutWindow();
	void slotQuit();
};

#endif // _KGMAILNOTIFIER_H_
