/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2005 by the KFTPGrabber developers
 * Copyright (C) 2003-2005 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
#ifndef KFTPSERVERMANAGEMENTDIALOGWIDGET_H
#define KFTPSERVERMANAGEMENTDIALOGWIDGET_H

#include <qwidget.h>

class QSpinBox;
class QLineEdit;
class QLabel;
class QGridLayout;

class KPasswordEdit;

namespace KFTPWidgets {

namespace ServerManagement {

class ListViewItem;

enum Attribute {
  NO = 0, /**< false */
  OPTIONAL /**< optional */
};

/**
 * @author Blacknator
 *
 * @brief this class creates a widget for the dialog
 *
 * this class is called from the dialog if a widget is needed<br>
 * the item in the constructor defines which widget to create
 */
class DialogWidget : public QWidget
{
Q_OBJECT
public:
    enum Widget {
      VALUE = 0, ///< Value Widget
      STRING, ///< String Widget
      PASSWORD ///< Password Widget
    };
    
    DialogWidget(ListViewItem *item, QString arg, QWidget *parent = 0, const char *name = 0);
    ~DialogWidget();

    /** initialize the class */
    void init();

    /** @return the text of the widget that was created */
    QString text();
    /** @return the error message if the argument was not optional and no input */
    QString error() { return m_argError; }
    bool optional() { if (m_attribute == OPTIONAL) return true; else return false; }
private:
    /** check if the argument is optional or not */
    void checkOptional();

    /**
     * creates a QLabel and an QSpinBox
     * @param label the text of the label
     */
    void createValue(QString label);
    /**
     * creates a QLabel and a QLineEdit
     * @param label the text of the label
     */
    void createString(QString label, QString error);

    /** create two password widget */
    void createPassword(QString error);
private:
    /** @brief the clicked item in the list view */
    ListViewItem *m_item;
    /** @brief Dialog layout */
    QGridLayout *m_layout;

    /** @brief the argument of the clicked item */
    QString m_arg;
    /** @brief the error message if the argument is not optional and nothing is input */
    QString m_argError;
    /** @brief holds if the widget is optional or not */
    Attribute m_attribute;
    /** @brief memorize which widget was created */
    Widget m_argWidget;

    /** @brief QLabel in the dialog - left besides another widget */
    QLabel *m_label;
    /** @brief QSpinBox in the dialog */
    QSpinBox *m_spinBox;
    /** @brief QLineEdit in the dialog */
    QLineEdit *m_lineEdit;

    /** @brief QLabel in the dialog - left besides the QLineEdit */
    QLabel *m_passwordLabel1;
    QLabel *m_passwordLabel2;
    /** @brief QLineEdit in the dialog */
    KPasswordEdit *m_passwordEdit1;
    KPasswordEdit *m_passwordEdit2;

};

}

}

#endif
