/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 * Copyright (C) 2005 Markus Brueffer <markus@brueffer.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPQUEUEVIEW_H
#define KFTPQUEUEVIEW_H

#include <qguardedptr.h>

#include <qlayout.h>
#include <qlabel.h>

#include <kaction.h>
#include <klistview.h>

#include "kftpqueue.h"

class KToolBar;
class KListViewSearchLine;

namespace KFTPWidgets {

class ListView;

class QueueViewItem : public QObject, public QListViewItem
{
Q_OBJECT
public:
    QueueViewItem(KFTPQueue::QueueObject *object, QListView *parent);
    QueueViewItem(KFTPQueue::QueueObject *object, QListViewItem *parent);

    void setObject(KFTPQueue::QueueObject *object) { m_queueObject = object; }
    KFTPQueue::QueueObject *getObject() { return m_queueObject; }

    int compare(QListViewItem *i, int col, bool) const;
    void refresh();
    virtual void paintCell(QPainter *p, const QColorGroup &cg, int column, int width, int alignment);
private:
    QGuardedPtr<KFTPQueue::QueueObject> m_queueObject;
private slots:
    void slotUpdateItemRequested();
};

/**
 * @author Jernej Kos
 */
class QueueView : public QWidget
{
Q_OBJECT
public:
    QueueView(QWidget *parent = 0, const char *name = 0);
    ~QueueView();

    void loadLayout();
    void saveLayout();
    
    void initActions();
    void initToolBar();
    
public slots:    
    void updateActions();

private:
    // Actions
    KAction *m_launchAction;
    KAction *m_abortAction;
    KAction *m_removeAction;
    KAction *m_removeAllAction;
    KAction *m_moveUpAction;
    KAction *m_moveDownAction;
    KAction *m_editAction;
    
    // Toolbar Actions
    KAction *m_loadAction;
    KAction *m_saveAction;
    KAction *m_startAction;
    KAction *m_pauseAction;
    KAction *m_stopAction;
    KAction *m_addAction;
    KAction *m_searchAction;
    KToggleAction *m_filterAction;
    
    KListViewSearchLine *m_searchField;

    KToolBar *m_toolBar;
    KToolBar *m_searchToolBar;
    KFTPWidgets::ListView *m_queue; 
    
    KActionCollection *actionCollection();

private slots:
    void slotQueueUpdate();
    
    void slotObjectRemoved(long);
    
    void slotTransferAdded(KFTPQueue::Transfer*);
    void slotSiteAdded(KFTPQueue::Site*);
    
    void contextMenuRequested(KListView*, QListViewItem*, const QPoint&);
    
    void slotSearchEraseClicked();
    
    // Slots for actions
    void slotLaunch();
    void slotAbort();
    void slotRemove();
    void slotRemoveAll();
    void slotMoveUp();
    void slotMoveDown();
    void slotEdit();
    
    void slotLoad();
    void slotSave();
    void slotStart();
    void slotPause();
    void slotStop();
    void slotAdd();
    void slotSearch();
    void slotFilter();
};

}

#endif
