/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPFILEDIRTREEVIEW_H
#define KFTPFILEDIRTREEVIEW_H

#include <klistview.h>
#include <klocale.h>
#include <kurl.h>

#include <qpixmap.h>
#include <qdict.h>

namespace KFTPWidgets {

namespace Browser {

class TreeViewItem;

/**
@author Jernej Kos
*/
class TreeView : public KListView
{
Q_OBJECT
friend class ListView;
friend class TreeViewItem;
public:
    TreeView(QWidget *parent = 0, const char *name = 0);
    ~TreeView();

    int openURL(const KURL url, QListViewItem *parent = 0);
private:
    QDict<TreeViewItem> m_treeItems;
    bool m_noItemOpen;
    
    /* Drag & drop support */
    QListViewItem *m_dropItem;
    QDragObject *m_dragObject;
    
    QDragObject *dragObject();
    void startDrag();
    bool acceptDrag(QDropEvent *e);
    void contentsDragEnterEvent(QDragEnterEvent *e);
    void contentsDragMoveEvent(QDragMoveEvent *e);
    void contentsDragLeaveEvent(QDragLeaveEvent*);
    void contentsDropEvent(QDropEvent *e);
    
    void clearFolder(const KURL url);
    void removeFolder(const KURL url);
    void createFolder(const KURL url, QPixmap icon);
    void resetView(const KURL url, const QString &rootText = i18n("Root directory"));
    void endUpdate(const KURL url);
protected:
    QListViewItem *findItem(QListViewItem *parent, const QString &name);
private slots:
    void slotClicked(QListViewItem *item);
    void slotDoubleClicked(QListViewItem *item);
signals:
    void pathChanged(const KURL);
};

class TreeViewItem : public QListViewItem
{
friend class TreeView;
public:
    TreeViewItem(TreeView *parent, const KURL &url);
    TreeViewItem(TreeView *tree, QListViewItem *parent, const KURL &url);
    ~TreeViewItem();
    
    int compare(QListViewItem *i, int col, bool) const;
private:
    TreeView *m_tree;
    KURL m_url;
    bool m_dirty;
};

}

}

#endif
