/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include "kftpbookmarks.h"
#include "kftpbookmarksshare.h"
#include "kftpapi.h"
#include "misc.h"

#include <kapplication.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kurl.h>
#include <kmessagebox.h>

using namespace KFTPGrabberBase;

KFTPBookmarksShare::KFTPBookmarksShare(QObject *parent, const char *name)
 : QObject(parent, name)
{
#if KDE_IS_VERSION(3,3,0)
  m_imProxy = KIMProxy::instance(kapp->dcopClient());
  m_imProxy->initialize();
  
  connect(m_imProxy, SIGNAL(sigContactPresenceChanged(const QString&)), this, SLOT(updateContactsMenu()));
#endif

  m_contactsMenu = new KActionMenu(i18n("&Send Bookmarks To"), "kaddressbook", this);
}

KActionMenu *KFTPBookmarksShare::getContactList()
{
  updateContactsMenu();
  return m_contactsMenu;
}

void KFTPBookmarksShare::updateContactsMenu()
{
  m_contactsMenu->popupMenu()->clear();
  
#if KDE_IS_VERSION(3,3,0)
  if (m_imProxy->fileTransferContacts().count() > 0) {
    QStringList contacts = m_imProxy->fileTransferContacts();
    QStringList::Iterator end( contacts.end() );
    for (QStringList::Iterator i( contacts.begin() ); i != end; ++i) {
      KAction *action = new KAction(m_imProxy->displayName(*i), m_imProxy->presenceIcon(*i), KShortcut(), this, SLOT(slotContactClicked()), KFTPAPI::getInstance()->mainWindow()->actionCollection(), (*i).ascii());
      m_contactsMenu->insert(action);
    }
  } else {
    KAction *disabledAction = new KAction(i18n("<No contacts are available>"));
    disabledAction->setEnabled(false);
    m_contactsMenu->insert(disabledAction);
  }
#else
  KAction *disabledAction = new KAction(i18n("<Disabled in this version of KDE>"));
  disabledAction->setEnabled(false);
  m_contactsMenu->insert(disabledAction);
#endif
}

void KFTPBookmarksShare::slotContactClicked()
{
#if KDE_IS_VERSION(3,3,0)
  QString contactUid = QObject::sender()->name();
  QString contactName = ((KAction*)QObject::sender())->text();
  
  if (KMessageBox::questionYesNo(0, i18n("<qt>You are about to send your KFTPGrabber bookmarks to <b>%1</b>. They may contain passwords or sensitive X509 certificates: sending your bookmarks may compromise their safety.<br><br>Are you sure?</qt>").arg(contactName), i18n("Send Bookmarks")) == KMessageBox::No) {
    return;
  }
  
  FTPBookmarkManager->save();
  m_imProxy->sendFile(contactUid, KURL(getStoreDir("bookmarks.xml")), "kftpgrabber-bookmarks.xml");
#endif
}

#include "kftpbookmarksshare.moc"
