/***************************************************************************
                          kfvdate.h  -  description
                             -------------------
    begin                : Mon Sep 24 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFVDATE_H
#define KFVDATE_H

#include <qwidget.h>
#include <qdatetime.h>
#include <qlineedit.h>
#include <qpushbutton.h>

/**View class for QDates
  *@author Jeffrey Yu
  */

class KFVDate : public QWidget  {
   Q_OBJECT
public: 
	KFVDate(QWidget *parent=0, const char *name=0);
	~KFVDate();
	
	/** Retrieve the view's date */
	QDate date() const {return date_;};
	/** Specify a new date for the view */
	void date(const QDate& date);
	
signals:
	/** Signal sent when the user changes the view's date */
	void dateChanged(const QDate& date);
	
private:
	/** View's current date */
	QDate date_;
	/** Lineedit to display the current date */
	QLineEdit* leDate_;
	/** Pushbutton to edit the current date */
	QPushButton* pbEdit_;

	/** Create child widgets for the view */
	void createWidgets();
	
private slots:
	/** Slot to receive clicks of the edit pushbutton */
	void onPbEditClicked();
};

#endif
