/***************************************************************************
                          kfocuslogentriesview.cpp  -  description
                             -------------------
    begin                : Sun Aug 19 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlayout.h>
#include <qlabel.h>

#include "kfocuslogentriesview.h"
#include "kfocuslogbook.h"
#include "kfocuslogentry.h"
#include "kdatedialog.h"

#include "kfvlog.h"

KFVLogBook::KFVLogBook(QWidget *parent, const char *name ) : QWidget(parent,name) {
	logBook_ = NULL;
	logBookWidgetsOn_ = false;
	pbNewEntryEnabled_ = false;
	pbDeleteEntryEnabled_ = false;
	
	createWidgets();
}

KFVLogBook::~KFVLogBook(){
	//logBook(NULL);
}


/** Retrieve the current logBook for this view */
KFMLogBook* KFVLogBook::logBook() const{
	return logBook_;
}

/** Set the logBook for this view */
void KFVLogBook::logBook(KFMLogBook* logBook){
	if (logBook != logBook_) {
		if (logBook_ != NULL) {
			setEnabled(false);
		
			disconnect(logBook_, 0, this, 0);
			
			logBookWidgetsOn(false);
			pbNewEntryEnabled(false);
		}
		
		logBook_ = logBook;
		if (logBook_ != NULL) {
			logBookWidgetsOn(true);
			pbNewEntryEnabled(true);
			
			connect(logBook_, SIGNAL( entryAdded(KFMLog*) ),
							this, SLOT( onLogBookEntryAdded(KFMLog*) ));
			connect(logBook_, SIGNAL( entryRemoved(KFMLog*,int) ),
							this, SLOT( onLogBookEntryRemoved(KFMLog*, int) ));
		
			setEnabled(true);			
		}
	}
}


void KFVLogBook::createLeftWidgets(QLayout* lParent){
		QVBoxLayout* vbl = new QVBoxLayout(lParent);
			vbl->addWidget(new QLabel("Log",this));
			
			lbEntries_ = new QListBox(this);
				lbEntries_->setMinimumWidth(130);
				lbEntries_->setSizePolicy(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding));
				vbl->addWidget(lbEntries_);

			QHBoxLayout* hbl = new QHBoxLayout(vbl);
				hbl->setSpacing(5);
				
				pbNewEntry_ = new QPushButton("N&ew", this);
					pbNewEntry_->setSizePolicy(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Fixed));
					hbl->addWidget(pbNewEntry_);
				
				pbDeleteEntry_ = new QPushButton("De&lete", this);
					pbDeleteEntry_->setSizePolicy(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Fixed));
					pbDeleteEntry_->setEnabled(false);
					hbl->addWidget(pbDeleteEntry_);
}

/** Make the widgets in this view */
void KFVLogBook::createWidgets(){
	QHBoxLayout* hbl = new QHBoxLayout(this);
		hbl->setSpacing(7);
		
		createLeftWidgets(hbl);
		
		QFrame* frame = new QFrame(this);
			frame->setFrameStyle(QFrame::VLine | QFrame::Raised);
			hbl->addWidget(frame);

		QVBoxLayout* vbl = new QVBoxLayout(hbl);
			vLog_ = new KFVLog(this);
				vbl->addWidget(vLog_);
}


/** Check the status of the logBook widgets */
bool KFVLogBook::logBookWidgetsOn() const {
	return logBookWidgetsOn_;
}

/** Change the status of the logBook widgets */
void KFVLogBook::logBookWidgetsOn(const bool on) {
	if (on != logBookWidgetsOn_) {
		if (on) {
			// Do stuff to view the logBook contents
			if (logBook_->numEntries() > 0) {
				loadEntriesListBox();
				lbEntries_->setEnabled(true);
				
				logBook_->currentPosition(lbEntries_->currentItem());
				vLog_->log(logBook_->currentEntry());
				
				pbDeleteEntryEnabled(true);
				
				logBookWidgetsOn_ = on;
			}
			
			// logBookWidgetsOn_ does not change if the logBook has 0 entries
		}
		else {
			// Do stuff to clear the logBook view
			pbDeleteEntryEnabled(false);
			
			vLog_->log(NULL);
			
			lbEntries_->setEnabled(false);
			unloadEntriesListBox();
		
			logBookWidgetsOn_ = on;		
		}
	}
}


/** Load up the entries list box with entry dates */
void KFVLogBook::loadEntriesListBox(){
	logBook_->currentEntry(logBook_->firstEntry());
	while (logBook_->currentEntry() != NULL) {
		lbEntries_->insertItem(logBook_->currentEntry()->dateString());	
		logBook_->currentEntry(logBook_->nextEntry());
	}
	lbEntries_->setCurrentItem(0);
	connect(lbEntries_, SIGNAL( currentChanged(QListBoxItem*) ),
					this, SLOT( onEntriesListBoxCurrentChanged(QListBoxItem*) ));
}

/** Clear out the contents of the entries listbox */
void KFVLogBook::unloadEntriesListBox(){
	disconnect(lbEntries_, 0, this, 0);
	lbEntries_->clear();
}


/** Read the state of the new-entry pushbutton */
bool KFVLogBook::pbNewEntryEnabled() const{
	return pbNewEntryEnabled_;
}

/** Change the state of the new-entry pushbutton */
void KFVLogBook::pbNewEntryEnabled(bool enabled){
	if (pbNewEntryEnabled() != enabled) {
		if ( !enabled ) {
			disconnect(pbNewEntry_, 0, this, 0);
			pbNewEntry_->setEnabled(false);
		}
		
		pbNewEntryEnabled_ = enabled;
		if ( enabled ) {
			connect(pbNewEntry_, SIGNAL( clicked() ),
							this, SLOT( onNewEntryPushButtonClicked() ));
			pbNewEntry_->setEnabled(true);		
		}
	}
}


/** Read the state of the delete-entry pushbutton */
bool KFVLogBook::pbDeleteEntryEnabled() const{
	return pbDeleteEntryEnabled_;
}

/** Change the state of the delete-entry pushbutton */
void KFVLogBook::pbDeleteEntryEnabled(bool enabled){
	if (pbDeleteEntryEnabled() != enabled) {
		if ( !enabled ) {
			disconnect(pbDeleteEntry_, 0, this, 0);
			pbDeleteEntry_->setEnabled(false);
		}
		
		pbDeleteEntryEnabled_ = enabled;
		if ( enabled ) {
			connect(pbDeleteEntry_, SIGNAL( clicked() ),
							this, SLOT( onDeleteEntryPushButtonClicked() ));
			pbDeleteEntry_->setEnabled(true);
		}
	}
}


/** Slot to receive currentChanged from the entries listbox */
void KFVLogBook::onEntriesListBoxCurrentChanged(QListBoxItem* item){
	if (item == NULL) {
		vLog_->log(NULL);
	}
	else {
		lbEntries_->setSelected(item, true);
	
		logBook_->currentPosition(lbEntries_->currentItem());
		vLog_->log(logBook_->currentEntry());
	}
}


/** Slot for when the logBook adds an entry */
void KFVLogBook::onLogBookEntryAdded(KFMLog* entry){
	if (logBook_ == NULL) return;
	
	if (logBook_->numEntries() == 1) {
		logBookWidgetsOn(true);
	}
	else {
		// Add another item to the entries listbox
		logBook_->currentEntry(entry);
		if (logBook_->currentEntry() != NULL) {
			// Add the name of the new entry to the listbox
			lbEntries_->insertItem(logBook_->currentEntry()->dateString(),
														 logBook_->currentPosition());
														
			// Adjust the current item in the listbox
			lbEntries_->setCurrentItem(logBook_->currentPosition());
		}
	}
}


/** Slot for when the logBook removes an entry */
void KFVLogBook::onLogBookEntryRemoved(KFMLog*, int pos){
	if (logBook_ == NULL) return;
	
	if (logBook_->numEntries() == 0) {
		logBookWidgetsOn(false);
	}
	else {
		// Calling QListBox::setCurrentItem() doesn't work correctly here
		// because the logBook and the listbox are out of sync.  Luckily,
		// QListBox::removeItem does the right thing and automatically changes
		// the current item in a logical manner.
	
		// Remove the name of the deleted entry	from the listbox
		lbEntries_->removeItem(pos);
	}
}

#include <stdio.h>
/** Slot to receive clicked signal from the new-entry pushbutton */
void KFVLogBook::onNewEntryPushButtonClicked(){
	KDateDialog dlg;
	if (dlg.exec()) {
		KFMLog* entry = new KFMLog();
		entry->date(dlg.date());
		logBook_->addEntry(entry);	
	}
}

/** Slot to receive clicked from the delete-entry pushbutton */
void KFVLogBook::onDeleteEntryPushButtonClicked(){
	logBook_->currentPosition(lbEntries_->currentItem());
	logBook_->removeEntry(logBook_->currentEntry());	
}

