/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : Main window,create menu,main widget,status bar
 * 
 * Copyright 2005 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#include <kconfig.h>
#include <klocale.h>
#include <kshortcut.h>
#include <kstatusbar.h>
#include <kstdaction.h>
#include <kmainwindow.h>
#include <kactioncollection.h>

#include "kflickr.h"
#include "kflickrwidget.h"


/**
 * Constructor. Setup the menu and creates the kflickrWidget
 * instance as the central widget for the application.
 */
kflickr::kflickr()
    : KMainWindow(0, "kflickr")
{  
    // create the main widget  
    m_TheWidget = new kflickrWidget(this);
    
    // Create our actions for menus etc...
    KStdAction::quit(this, SLOT(close()), actionCollection());
    
    // The big four actions
    new KAction(i18n("&Add"), "add", KShortcut("CTRL++"), m_TheWidget,
        SLOT(addPhotos()), actionCollection(), "add_photos");
    new KAction(i18n("&Remove"), "remove", KShortcut("CTRL+-"), m_TheWidget,
        SLOT(removePhotos()), actionCollection(), "remove_photos");
    new KAction(i18n("&Edit"), "edit", KShortcut("CTRL+e"), m_TheWidget,
        SLOT(onEditSelected()), actionCollection(), "edit_photos");
    new KAction(i18n("&Upload"), "up", KShortcut("CTRL+u"), m_TheWidget,
        SLOT(uploadPhotos()), actionCollection(), "upload_photos");

    // Setep the GUI as defined in the rc file
    createGUI("kflickrui.rc");
    
    // We don't currently have support for these so disable them
    actionCollection()->action("help_whats_this")->setEnabled(false);
    
    // create connections
    connect(m_TheWidget, SIGNAL(enableEdit(bool)), this, SLOT(setEditState(bool)));
    connect(m_TheWidget, SIGNAL(enableRemove(bool)), this, SLOT(setRemoveState(bool)));
    connect(m_TheWidget, SIGNAL(enableUpload(bool)), this, SLOT(setUploadState(bool)));
    
    // Create the statusbar
    statusBar()->insertItem(i18n("Unused Upload Bandwidth: "), 0);    
    
    // Force buttons states to be looked at
    m_TheWidget->updateActionStates();
    
    // Set the main widget
    setCentralWidget(m_TheWidget);
    setAutoSaveSettings();
}

/**
 *  Destructor. Cleanup anything that we have created using 'new'.
 */
kflickr::~kflickr()
{
    delete m_TheWidget;
}


/*!
    \fn kflickr::newBandwidthValue(int)
 */
void kflickr::newBandwidthValue(const QString &value)
{    
    statusBar()->changeItem(i18n("Unused Upload Bandwidth: %1").arg(value), 0);
}


/*!
    \fn kflickr::setEditState(bool state)
 */
void kflickr::setEditState(bool state)
{
    actionCollection()->action("edit_photos")->setEnabled(state);
}


/*!
    \fn kflickr::setRemoveState(bool state)
 */
void kflickr::setRemoveState(bool state)
{
    actionCollection()->action("remove_photos")->setEnabled(state);
}


/*!
    \fn kflickr::setUploadState(bool state)
 */
void kflickr::setUploadState(bool state)
{
    actionCollection()->action("upload_photos")->setEnabled(state);
}


#include "kflickr.moc"
