.TH BT 1 "31 March, 2004"
.SH NAME
bt \- Stack Traceback command
.SH SYNOPSIS
bt [ <stack-frame-address> ]
.LP
btp <pid>
.LP
btt <struct-task-address>
.LP
bta [ DRSTZUIMA ]
.LP
btc [<cpu>]
.SH DESCRIPTION
.hy 0
The
.B bt
command is used to print a stack traceback.  It uses the
current registers (see \fBrd\fP command) to determine
the starting context and attempts to provide a complete
stack traceback for the active thread.   If \fIstack-frame-address\fP
is supplied, it is assumed to point to the start of a valid
stack frame and the stack will be traced back from that
point (e.g. on i386 architecture, \fIstack-frame-address\fP
should be the stack address of a saved \fB%eip\fP value from a \fBcall\fP
instruction. on sparc64 architecture, it should be a pointer to a
saved register window, as is found in the \fB%fp\fP register).
.P
If present, a kernel configuration option \fBCONFIG_FRAME_POINTER\fP
should be enabled so that the compiler will utilize the frame pointer
register properly to maintain a stack which can be correctly
analyzed. Some architectures (e.g. sparc64) always use
\fBCONFIG_FRAME_POINTER\fP, and so the option is not present.
.P
The \fBbt\fP command will attempt to analyze the stack without
frame pointers if the \fBCONFIG_FRAME_POINTER\fP option is not
enabled, but the analysis is difficult and may not produce
accurate nor complete results.
.P
The \fBbtp\fP command will analyze the stack for the given
process identification (see the \fBps\fP command).
.P
The \fBbtt\fP command will analyze the stack for the given task
structure.
It is exactly equivalent to \fBbtp\fR on the pid extracted from the
task structure.
.P
The \fBbta\fP command lists the stack for all processes in the desired
state.
Without any parameters, \fBbta\fP gives a backtrace for all useful processes.
If a parameter is specified, it is a single string consisting of the
letters D, R, S, T, Z, U, I, M and A in any order.
See the kdb \fBps\fR man page for more details.
.P
The \fBbtc\fP command will analyze the stack for the current process on
a specified cpu or, if no cpu number is supplied, for the current
process on all cpus.
It does not switch to the other cpus, instead it uses the task
structures to identify and issue \fBbtt\fR against the current task on
the desired cpus.
.P
For each function, the stack trace prints at least two lines.
The first line contains four or five fields\ :-
.IP * 3
The pointer to the previous stack frame, blank if there is no valid
frame pointer.
.PD 0
.IP * 3
The current address within this frame.
.IP * 3
The address converted to a function name (actually the first non-local
label which is <= the address).
.IP * 3
The offset of the address within the function.
.IP * 3
Any parameters to the function.
.PD 1
.PP
On the next line there are five fields which are designed to make it
easier to match the trace against the kernel code\ :-
.IP * 3
The module name that contains the address, "kernel" if it is in the
base kernel.
.PD 0
.IP * 3
The section name that contains the address (not available on 2.6 kernels).
.IP * 3
The start address of the section (not available on 2.6 kernels).
.IP * 3
The start address of the function.
.IP * 3
The end address of the function (the first non-local label which is >
the address).
.PD 1
.PP
If arguments are being converted to symbols, any argument which
converts to a kernel or module address is printed as\ :-
.IP * 3
Argument address.
.PD 0
.IP * 3
The module name that contains the address, "kernel" if it is in the
base kernel.
.IP * 3
The symbol name the argument maps to.
.IP * 3
The offset of the argument from the symbol, suppressed if 0.
.PD 1
.SH MATCHING TRACE TO KERNEL CODE
The command "objdump\ -S" will disassemble an object and, if the code
was compiled with debugging (gcc flag -g), objdump will interleave the
C source lines with the generated object.
.PP
A complete objdump of the kernel or a module is too big, normally you
only want specific functions.
By default objdump will only print the .text section but Linux uses
other section names for executable code.
When objdump prints relocatable objects (modules) it uses an offset of
0 which is awkward to relate to the stack trace.
The five fields which are printed for each function are designed to
make it easier to match the stack trace against the kernel code using
"objdump\ -S".
.PP
If the function is in the kernel then you need the section name, the
start and end address of the function.  The command is
.PP
.nf
  objdump -S -j <section_name> \\
          --start-address=<start-address> \\
          --stop-address=<end-address> \\
          /usr/src/linux/vmlinux
.fi
.PP
If the function is in a module then you need the section name, the
start address of the section, the start and end address of the
function, the module name.  The command is
.PP
.nf
  objdump -S -j <section_name> \\
          --adjust-vma=<section-start> \\
          --start-address=<start-address> \\
          --stop-address=<end-address> \\
          /path/to/module/<module-name>.o
.fi
.PP
Unfortunately the 2.6 kernel does not provide the information required
to locate the start of the section, which makes it very difficult to
perform a reliable objdump on a module.
.PP
All addresses to objdump must be preceded by '0x' if they are in hex,
objdump does not assume hex.
The stack trace values are printed with leading '0x' to make it easy to
run objdump.
.SH LIMITATIONS
If the kernel is compiled without frame pointers, stack tracebacks
may be incomplete.  The \fBmds %esp\fP (i386) or \fBmds %fp\fP (sparc64)
command may be useful in attemping to determine the actual stack
traceback manually.
.P
A stack trace can be misleading if any code in a function exit has been
executed, the stack is partially unwound at that stage.
.P
The \fBbt\fP command may print more arguments for a function
than that function accepts;  For sparc64, this will always happen
as the debugger cannot determine the correct number. For i386, this happens
when the C compiler doesn't immediately pop the arguments off the stack upon
return from a called function.  When this is this case, these extra
stack words will be considered additional arguments by the \fBbt\fP
command.
.SH ENVIRONMENT
The \fBBTARGS\fP environment variable governs the maximum number
of arguments that are printed for any single function.
.PP
If the \fBBTSYMARG\fP environment variable is non-zero then any
arguments that fall within the kernel are converted to symbols.
.PP
If the \fBNOSECT\fP environment variable is non-zero then the
section information is suppressed.
The default is NOSECT=1 so section data is suppressed; use set\ NOSECT=0
to see section information.
.PP
The \fBBTAPROMPT\fP environment variable controls the prompt after each
process is listed by the \fBbta\fP command.  If \fBBTAPROMPT\fP is not
set or is non-zero then \fBbta\fP issues a prompt after each process is
listed.  If \fBBTAPROMPT\fP is set to zero then no prompt is issued and
all processes are listed without human intervention.
.PP
\fBba\fB with no parameters uses the \fBPS\B environment variable, see
the kdb \fBps\fR man page.
.SH SMP CONSIDERATIONS
None.
.SH EXAMPLES
.nf
.na
.ft CW
Entering kdb (0xc3cb4000) due to Breakpoint @ 0xc011725d
Instruction(i) breakpoint #0 at 0xc011725c
qm_modules+0xd1:   movl   %ebp,%esp
kdb> bt
    EBP       EIP         Function(args)
0xc3cb5f98 0xc011725d  qm_modules+0xd1 (0x80721c0, 0x100, 0xbfff5000)
                       kernel .text 0xc0100000 0xc011718c 0xc0117264
0xc3cb5fbc 0xc0117875  sys_query_module+0x1b1 (0x0, 0x1, 0x80721c0, 0x100, 0xbfff5000)
                       kernel .text 0xc0100000 0xc01176c4 0xc01178e8
           0xc01095f8  system_call+0x34
                       kernel .text 0xc0100000 0xc01095c4 0xc01095fc
