/*
 *
 *  Kepas - KDE Easy Publish and Share
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kepas.
 *
 *  kepas is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kepas is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kepas; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#ifndef TRAYICON_H
#define TRAYICON_H

#include <QSystemTrayIcon>
#include <QtDBus>
#include <KConfig>

#include <kdialog.h>
#include <kaboutapplicationdialog.h>
#include <kaboutdata.h>
#include <KConfig>
#include <KConfigGroup>

#include <QMainWindow>
#include <QApplication>

#include <lib/servicelocator.h>
#include <lib/buddylist.h>
#include <lib/ui_config.h>
#include <lib/ui_noteEditor.h>

#include <libkpf/ServerWizard.h>
#include <libkpf/WebServerManager.h>
#include <libkpf/WebServer.h>
#include <libkpf/ActiveMonitorWindow.h>
#include <libkpf/SingleServerConfigDialog.h>

using namespace KPF;

class TrayIcon : public QDBusAbstractAdaptor
//class TrayIcon : public QMainWindow
	 	 	 	 
{
Q_OBJECT
Q_CLASSINFO("D-Bus Interface", "org.kde.kepas")


public:
	 TrayIcon(QApplication* parent = 0);
	 ~TrayIcon();
	 
private:
	 QSystemTrayIcon* tray;
//	 KSystemTrayIcon* tray;
	 ServiceLocator* avahiClient;
	 QMenu* mainmenu;
	 QMenu* clipMenu;
	 QMenu* kpfMenu;
	 QMenu* newServerMenu;
	 

	 QAction* buddyAction;
	 QAction* serverAction;
	 QAction* configAction;
	 QAction* clipAction;
	 QAction* quitAction;
	 QAction* sendFileAction;
	 QAction* newServerAction;
	 QAction* monitorAction;
	 QAction* pauseAction;
	 QAction* removeAction;
	 QAction* restartAction;
	 QAction* prefAction;
         QAction* sendNoteAction;
	 
	 BuddyList* buddylist;
//	 KConfig* config;

	 QDBusConnection* dbus;
	 KDialog* m_dialog;
	 KDialog* m_dialogNotes;
	 Ui::Config ui;
         Ui::noteEdit noteEdit;

	 ServerWizard* publicServerWiz;
	 QHash<QString,WebServer*>* webServerHash;
	 QHash<QString,QMenu*>* webServerMenuHash;
	 QHash<QString,QAction*>* actionHash;
	 WebServer* webSrv;
	 SingleServerConfigDialog* configDialog;
	 
	 void addClipEntries();	 
	 KConfig* config;
	 KConfigGroup* confGroup;

public slots:
         void SendKNote(QString text);
         void SendKlipperEntry(QString entry);
         void SendFile(QString filename);

private slots:
	 void slotBuddyList(bool);
	 void slotServerWizard(bool);
	 void slotSendClipEntry(QAction*);
	 void slotQuitApp(bool);
	 void slotTrayActivated(QSystemTrayIcon::ActivationReason reason);
	 void slotShowToolTip(QAction* action);
	 void slotFileSelect(bool);
         void slotDefineNote(bool);
         void slotSendNote();
	
	 void configAccepted();
	 void slotSelectDir();
	 void showConfigurationInterface();
	 void serviceRunning();
	 void showAboutInfo();
	 void slotWizardDying(ServerWizard * wiz);
	 void slotMonitorAction(QAction*);
	 void slotRemoveServerAction(QAction*);
	 void slotPauseServerAction(QAction*);
	 void slotRestartServerAction(QAction*);
	 void slotPrefsServerAction(QAction*);
	 void slotConfigDialogDying(SingleServerConfigDialog* dialog);
	 void slotServerMenuTriggered(QAction*);
	

};


#endif
