/*
 *
 *  Kepas - KDE Easy Publish and Share
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kepas.
 *
 *  kepas is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kepas is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kepas; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#include <kuniqueapplication.h>
#include <iostream>
#include <kcomponentdata.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>

#include "trayicon.h"


int main(int argc, char *argv[])
{
	
static const char *description =
    I18N_NOOP("kepas");

	KAboutData aboutData("kepas",
               I18N_NOOP("Kepas"),
               ki18n("Kepas - KDE Easy Publish and Share"),"0.9",
       	ki18n(description), KAboutData::License_GPL);
	aboutData.addAuthor(ki18n("Tom Patzig"), KLocalizedString(), "tpatzig@suse.de", "http://www.kde.org/");

	
	KComponentData component(&aboutData);

    KCmdLineArgs::init( argc, argv, &aboutData );

    KUniqueApplication::addCmdLineOptions();

    
    if (!KUniqueApplication::start()) {
	fprintf(stderr, "Kepas is already running!\n");
        return 0;
    }

//  QApplication a(argc, argv);

    KUniqueApplication a;

    a.disableSessionManagement();
    a.setQuitOnLastWindowClosed( false );

    
    TrayIcon main;
    
    return a.exec();

}
