#ifndef _TRACE_H
#define _TRACE_H

#ifdef ENABLE_TRACING
  extern void INIT_TRACE(void);
  extern void SHOW_TRACE(void);
  extern void DUMP_TRACE(const char *file);
  
  /*
   * Lets admit it, shall we. C macros are sometimes are so much cooler than
   * C++ static inlines ;) 
   * WARNING: fmt has to be a static string
   */
  #define TRACE(fmt,args...) \
        do { qDebug("~%s - \t" fmt, __PRETTY_FUNCTION__, ##args); } while (0)

  #define SHOW_TRACE_TEXT "Show Trace"
  
#else // !ENABLE_TRACING

  #define INIT_TRACE()
  #define TRACE(fmt, ...)
  #define SHOW_TRACE()
  #define SHOW_TRACE_TEXT QString::null
  #define DUMP_TRACE(file)

#endif  // ENABLE_TRACING

#endif // _TRACE_H

