/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DTREELISTITEM_H
#define _DTREELISTITEM_H

#include <klistview.h>
#include "DGuiItem.h"
#include "DItem.h"

class DDataItem;
class DTreeListView;
class QDropEvent;
/**
 * Mindmap item view
 *
 * @short Mindmap item view
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class DTreeListItem : public KListViewItem, public DGuiItem
{
    public:
	DTreeListItem(DTreeListView*, int id);
	virtual ~DTreeListItem();	

	virtual void update();

	virtual int compare(QListViewItem*, int, bool) const;

	void paintCell( QPainter * p, const QColorGroup & cg, 
		int column, int width, int align );

	QString tipText();
};

#endif // _DTREELISTITEM_H
