/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qpixmap.h>
#include <qlayout.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kmdichildview.h>
#include <kdebug.h>
#include <kparts/part.h>

#include "KDissertPart.h"
#include "KDissertView.h"
#include "DCanvasView.h"
	
	KDissertView::KDissertView( QWidget *parentWidget, const char *name )
: KMdiChildView( parentWidget, name )
{
	m_part = new KDissertPart(this, "kdissertpart", parent(), 0, 0);
	part()->widget()->setFocus();

	QBoxLayout* layout = new QHBoxLayout(this, 0, -1, "kdissertviewlayout" );
	part()->widget()->reparent( this, QPoint(0, 0) );
	layout->addWidget( part()->widget() );

	setFocusProxy(part()->widget());

	connect( m_part, SIGNAL(stateChanged()), this, SLOT(updateCaption()) );
	updateCaption();

	// add the tree view to the widget stack
	m_lwidget = (QWidget*) part()->treeview();

	//DCanvasView* canv = (DCanvasView*) (part()->widget());
	//m_cwidget = canv->addMiniView(m_lwidget);
}

KDissertView::~KDissertView()
{
	delete m_part->widget();
}

KDissertPart *KDissertView::part()
{
	return m_part;
}

void KDissertView::updateCaption()
{
	QString caption = QString::null;
	if (m_part->url().isValid()) caption = m_part->url().fileName();
	else caption = i18n("Untitled");

	if (m_part->isModified()) setIcon( SmallIcon("filesave") );
	else setIcon( QPixmap() );

	setMDICaption( caption );
}

#include "KDissertView.moc"
