/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qobject.h>

#include <kdebug.h>

#include "aux.h"
#include "DGuiView.h"
#include "DDataItem.h"
#include "DDataControl.h"


DGuiView::DGuiView(QWidget* parent, const char* name) : DBase( parent, name)
{
	m_data = NULL;
	m_readWrite = true;
}

DGuiView::~DGuiView()
{
}

void DGuiView::setDataTree(DDataControl* t)
{
	unplug();
	m_data = t;
	plug();
}

DDataControl* DGuiView::dataTree() const
{
	return m_data;
}

DDataItem* DGuiView::dataItem(int idx)
{
	if (!m_data) return NULL;
	return static_cast<DDataItem*> (m_data->Item(idx));
}

