/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DGENERATOR_H
#define _DGENERATOR_H

#include <qobject.h>

class QString;
class DDataControl;
class DDataItem;
class QTextStream;
/**
 * @short Base class for the document generators
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 */
class DGenerator : public QObject
{
	Q_OBJECT
	public:
		DGenerator();
		DGenerator(QObject*);
		virtual ~DGenerator();

		virtual const QString identifikation();
		virtual const QString fullName();
		virtual const QString group();
		virtual const QString description();
		virtual const QString quickstart();

		virtual bool generate(const QString &, DDataControl *);
		virtual bool writeMaindoc(DDataItem*, const QString &);

		virtual QWidget* confWidget();

		bool copyfiles(const QString &);
		bool generating;
		bool cli;

	protected:
		/// transform usual text into latex
		QString protectTex(const QString &);

		/// convert richtext to Tex commands
		QString htmlToTex(const QString &);

		/// make the string commented for LaTeX
		QString commentTex(const QString &);

		DDataControl* m_data;

		virtual void writeItem(DDataItem* item, QTextStream & s, int level);
		virtual void writePics(DDataControl* data, QString path);

		void notifyDocGenerated( const QString& );

	signals:
		void documentGenerated( const QString&, bool );
};

/// global functions

// remove all tags from a richtext string
QString wipeTags(const QString &);

#endif // _DGENERATOR_H
