#!/bin/sh
# Fancy colors used to beautify the output a bit.
#
NORMAL="\033[0m"
BOLD="\033[1m"
RED="\033[91m"
YELLOW="\033[93m"
GREEN="\033[92m"

# Checks for Python interpreter. Honours $PYTHON if set. Stores path to
# interpreter in $PYTHON.
#
checkPython()
{
	if [ -z $PYTHON ]; then
	  PYTHON=`which python 2> /dev/null`
	fi
	echo -n "Checking for Python               :  "
	if [ ! -x "$PYTHON" ]; then
	  echo -e $GREEN"not found!"$NORMAL
	  echo "Please make sure that the Python interpreter is available in your PATH"
	  echo "or invoke configure using the PYTHON flag, e.g."
	  echo "$ PYTHON=/usr/local/bin/python configure"
	  exit 1
	fi
	echo -e $GREEN"$PYTHON"$NORMAL
}

# Checks for SCons. Honours $SCONS if set. Stores path to 'scons' in $SCONS.
# Requires that $PYTHON is set.
#
checkSCons()
{
	echo -n "Checking for SCons                :  "
	if [ -z $SCONS ]; then
	  SCONS=`which scons-0.96.91 2> /dev/null`
	fi
	if [ ! -x "$SCONS" ]; then
	  echo -e $BOLD"not found, will use mini distribution."$NORMAL
	  tar xjf bksys/scons-mini.tar.bz2
	  SCONS="./scons"
	else
	  echo -e $GREEN"$SCONS"$NORMAL
	fi
	SCONS="$SCONS"
}

# Generates a Makefile. Requires that $SCONS is set.
#
generateMakefile()
{
	cat > Makefile << EOF
all:
	@$SCONS

# it is also possible to use
# @$SCONS -j4

install:
	@$SCONS install

clean:
	@$SCONS -c

uninstall:
	@$SCONS -c install

dist:
	@$SCONS dist

distclean:
	rm -rf cache/

cleanup:
	-find . -name '*~' | \
	  xargs rm
	-find . -name '*.ui' | \
	  xargs perl -pi -e 's#version="3.3"#version="3.2"#; s#^\ *<#<#'

EOF
}

checkPython
checkSCons
generateMakefile

$SCONS configure $@

#echo -e "You can now run:"
#echo -e $BOLD"./scons"$NORMAL
#echo -e $BOLD"./scons install"$NORMAL

