/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <kiconloader.h>
#include <klocale.h>

#include "settings.h"
#include "DDataControl.h"
#include "DTreeListItem.h"
#include "DTreeListView.h"
#include "DTreeListPopup.h"

// TODO the current implementation lets only select one item at a time
DTreeListPopup::DTreeListPopup(QWidget *parent) : KPopupMenu(parent)
{
	m_lstview = (DTreeListView*) parent;

	// new object
	insertItem(i18n("New item"), e_item);

	// edit actions
	if ( m_lstview->selectedItem() )
	{
		insertSeparator();
		insertItem(i18n("Delete"), e_delete);

		insertSeparator();
	}

	// disconnect actions

	KPopupMenu *disc_pop = new KPopupMenu(this, i18n("Disconnect"));
	// disc_pop ~ disconnect popup :)

	disc_pop->insertItem(i18n("Parent"), e_discon_parent);
	disc_pop->insertItem(i18n("Object(s)"), e_discon_obj);
	disc_pop->insertItem(i18n("Subtree"), e_discon_subtree);

	insertItem( i18n("Disconnect"), disc_pop);

	connect(disc_pop, SIGNAL(activated(int)), this, SIGNAL(activated(int)));
	if (m_lstview->selectedItem())
	{
		disc_pop->setItemEnabled(e_discon_subtree, m_lstview->selectedItem() );
		disc_pop->setItemEnabled(e_discon_obj, m_lstview->selectedItem() );

		DDataItem *item = m_lstview->dataTree()->singleSelection();
		if (item) disc_pop->setItemEnabled(e_discon_parent, item->Parent() != DItem::NOITEM);
	}
	else
	{
		disc_pop->setEnabled( false );
	}

	insertSeparator();

	// properties actions
	KPopupMenu *col_pop = new KPopupMenu(this, i18n("Colors"));

	col_pop->insertItem(i18n("Default color"), Settings::EnumColorMode::default_);
	if (Settings::annotation(Settings::EnumColorMode::theme1_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme1_), Settings::EnumColorMode::theme1_);
	else
		col_pop->insertItem(i18n("Theme 1"), Settings::EnumColorMode::theme1_);

	if (Settings::annotation(Settings::EnumColorMode::theme2_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme2_), Settings::EnumColorMode::theme2_);
	else
		col_pop->insertItem(i18n("Theme 2"), Settings::EnumColorMode::theme2_);

	if (Settings::annotation(Settings::EnumColorMode::theme3_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme3_), Settings::EnumColorMode::theme3_);
	else
		col_pop->insertItem(i18n("Theme 3"), Settings::EnumColorMode::theme3_);

	if (Settings::annotation(Settings::EnumColorMode::theme4_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme4_), Settings::EnumColorMode::theme4_);
	else
		col_pop->insertItem(i18n("Theme 4"), Settings::EnumColorMode::theme4_);

	if (Settings::annotation(Settings::EnumColorMode::theme5_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme5_), Settings::EnumColorMode::theme5_);
	else
		col_pop->insertItem(i18n("Theme 5"), Settings::EnumColorMode::theme5_);

	if (Settings::annotation(Settings::EnumColorMode::theme6_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme6_), Settings::EnumColorMode::theme6_);
	else
		col_pop->insertItem(i18n("Theme 6"), Settings::EnumColorMode::theme6_);

	col_pop->insertSeparator();
	col_pop->insertItem(i18n("Custom..."), Settings::EnumColorMode::custom_);

	if (m_lstview->selectedItem())
	{
		DTreeListItem *it = (DTreeListItem*) m_lstview->selectedItem();
		col_pop->setItemChecked( m_lstview->dataItem(it->Id())->colorScheme(), true);
	}

	connect(col_pop, SIGNAL(activated(int)), this, SIGNAL(activated(int)));

	insertItem( i18n("Colors"), col_pop);		
	col_pop->setEnabled( m_lstview->selectedItem() );

	insertItem(i18n("Properties..."), e_properties);
	setItemEnabled(e_properties, m_lstview->selectedItem() );
}
