/*  ksim - a system monitor for kde
 *
 *  Copyright (C) 2001  Robbie Ward <linuxphreak@gmx.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA  02110-1301, USA.
 */

#include "ksim.h"
#include "ksimview.h"
#include <ksimconfig.h>
#include <common.h>

#include <QLayout>
//Added by qt3to4:
#include <QResizeEvent>

#include <kaboutapplicationdialog.h>
#include <kbugreport.h>
#include <kaboutdata.h>
#include <dcopclient.h>
#include <kmessagebox.h>
#include <kglobal.h>
#include <klocale.h>>

extern "C"
{
  KDE_EXPORT KPanelExtension *init(QWidget *parent, const QString &configFile)
  {
    KGlobal::locale()->insertCatalog("ksim");
    return new KSim::PanelExtension(configFile, KPanelExtension::Normal,
    KPanelExtension::About | KPanelExtension::Help |
    KPanelExtension::Preferences | KPanelExtension::ReportBug,
    parent, "ksim");
  }
}

KSim::PanelExtension::PanelExtension(const QString &configFile,
   Type type, int actions, QWidget *parent, const char *name)
   : KPanelExtension(configFile, type, actions, parent, name)
{
  m_dcopClient = new DCOPClient;
  m_view = new KSim::MainView(config(), true, this, "m_view");
  m_view->positionChange(orientation());

  m_dcopClient->registerAs(name, false);

  m_aboutData = new KAboutData(name, 0, ki18n("KSim"), KSIM_VERSION_STRING,
     ki18n("A plugin based system monitor for KDE"),
     KAboutData::License_GPL, ki18n("(C) 2001-2003 Robbie Ward\n(C) 2005 Reuben Sutton"));
  m_aboutData->addAuthor(ki18n("Reuben Sutton"), ki18n("Maintainer"),"reuben.sutton@gmail.com");
  m_aboutData->addAuthor(ki18n("Robbie Ward"), ki18n("Original Author"),
     "linuxphreak@gmx.co.uk");
  m_aboutData->addAuthor(ki18n("Jason Katz-Brown"), ki18n("Developer"),
     "jason@katzbrown.com");
  m_aboutData->addAuthor(ki18n("Heitham Omar"), ki18n("Some FreeBSD ports"),
     "super_ice@ntlworld.com");
  m_aboutData->addAuthor(ki18n("Otto Bruggeman"), ki18n("Testing, Bug fixing and some help"),
     "bruggie@home.nl");
}

KSim::PanelExtension::~PanelExtension()
{
  delete m_aboutData;
  delete m_dcopClient;
}

QSize KSim::PanelExtension::sizeHint(Position p, QSize maxSize) const
{
  return m_view->sizeHint(p, maxSize);
}

void KSim::PanelExtension::resizeEvent(QResizeEvent *)
{
  m_view->resize(size());
}

KPanelExtension::Position KSim::PanelExtension::preferedPosition() const
{
  return KPanelExtension::Right;
}

void KSim::PanelExtension::reparse()
{
  emit updateLayout();
}

void KSim::PanelExtension::show()
{
  KPanelExtension::show();

  reparse();
}

void KSim::PanelExtension::about()
{
  KAboutApplicationDialog(m_aboutData).exec();
}

void KSim::PanelExtension::help()
{
}

void KSim::PanelExtension::preferences()
{
  m_view->preferences();
}

void KSim::PanelExtension::reportBug()
{
  KBugReport(this, true, m_aboutData).exec();
}

void KSim::PanelExtension::positionChange(Position)
{
  m_view->positionChange(orientation());
}

#include "ksim.moc"
