// -*- c++ -*-
/***************************************************************************
                           channelsuite.cpp
                           ----------------
    begin                : Sat Apr 10 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <qhbox.h>

#include <kdebug.h>
#include <kaction.h>
#include <klocale.h>
#include <kdialogbase.h>
#include <kxmlguifactory.h>
#include <kdetv.h>

#include "channelsuitewidgetimpl.h"
#include "channelsuite.h"

ChannelSuitePlugin::ChannelSuitePlugin( Kdetv *ktv, QWidget* parent )
    : KXMLGUIClient(),
      KdetvMiscPlugin( ktv, "channelsuite-misc", parent )
{
    setXMLFile("channelsuiteui.rc");
    _showAction = new KAction( i18n("Channelsuites"), "tv", 0,
                               actionCollection(), "show_channelsuitedlg" );

    connect( _showAction, SIGNAL( activated() ),
             this, SLOT( showDialog() ) );
}

ChannelSuitePlugin::~ChannelSuitePlugin()
{
}

void ChannelSuitePlugin::showDialog()
{
    KDialogBase* dlg = new KDialogBase(0, "ChannelSuite", true, i18n("Channelsuites"),
                                       KDialogBase::Ok | KDialogBase::Cancel,
                                       KDialogBase::Ok, true);
    QHBox* hbox = dlg->makeHBoxMainWidget();

    ChannelSuiteWidgetImpl* w = new ChannelSuiteWidgetImpl(driver(), _cfg, hbox, "ChannelSuiteDlg");

    connect(dlg, SIGNAL( okClicked() ),
            w,   SLOT( apply() ));
    connect(dlg, SIGNAL( cancelClicked() ),
            w,   SLOT( cancel() ));

    dlg->show();
}

void ChannelSuitePlugin::installGUIElements(KXMLGUIFactory* guiFactory, KActionCollection*)
{
    if ( guiFactory ) {
        guiFactory->addClient(static_cast<KXMLGUIClient*>(this));
    }
}

void ChannelSuitePlugin::removeGUIElements(KXMLGUIFactory*guiFactory, KActionCollection*)
{
    if ( guiFactory ) {
        guiFactory->removeClient(static_cast<KXMLGUIClient*>(this));
    }
}

extern "C"
{
    KdetvMiscPlugin* create_channelsuite( Kdetv *ktv, QWidget* parent )
    {
        return new ChannelSuitePlugin( ktv, parent );
    }
}

#include "channelsuite.moc"


// vim: ts=4 sw=4 et
