/***************************************************************************
                           kdetvformatconversionfilter.cpp
                           -------------------------------
    begin                : Thu Aug 26 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "kdetvformatconversionfilter.h"
#include "kdetvformatconversion.h"

KdetvFormatConversionFilter::KdetvFormatConversionFilter()
{
}

KdetvFormatConversionFilter::~KdetvFormatConversionFilter()
{
}

KdetvImage::ImageFormat KdetvFormatConversionFilter::inputFormats()
{
    return KdetvImage::FORMAT_ALL;
}

void KdetvFormatConversionFilter::setInputFormat(KdetvImage::ImageFormat fmt)
{
    _inputFormat = fmt;
}

KdetvImage::ImageFormat KdetvFormatConversionFilter::outputFormats()
{
    switch(_inputFormat) {
    case KdetvImage::FORMAT_BGR32:
        return (KdetvImage::ImageFormat)(KdetvImage::FORMAT_YUYV | KdetvImage::FORMAT_BGR32);
    case KdetvImage::FORMAT_BGR24:
        return (KdetvImage::ImageFormat)(KdetvImage::FORMAT_YUYV | KdetvImage::FORMAT_BGR24);
    case KdetvImage::FORMAT_YUV420P:
        return (KdetvImage::ImageFormat)(KdetvImage::FORMAT_YUYV | KdetvImage::FORMAT_YUV420P);
    default:
        return _inputFormat;
    }
}

void KdetvFormatConversionFilter::setOutputFormat(KdetvImage::ImageFormat fmt)
{
    _outputFormat = fmt;
}

KdetvSharedImage* KdetvFormatConversionFilter::filter(KdetvSharedImage* in, KdetvSharedImage* out)
{
    if( (_outputFormat != _inputFormat)    &&
        (_outputFormat &  outputFormats())    ) {
        out->setSize(in->size());
        out->setFormat(_outputFormat);
        out->setStride(0);
        out->setType(in->type());

        // FIXME: optimize
        switch(_inputFormat) {
        case KdetvImage::FORMAT_BGR32:
            KdetvFormatConversion::bgr32_to_yuyv(in->buffer(), out->buffer(), in->size().width(),
                                                 in->size().height(), in->stride(), out->stride());
            break;
        case KdetvImage::FORMAT_BGR24:
            KdetvFormatConversion::bgr24_to_yuyv(in->buffer(), out->buffer(), in->size().width(),
                                                 in->size().height(), in->stride(), out->stride());
            break;
        case KdetvImage::FORMAT_YUV420P:
            KdetvFormatConversion::yuv420p_to_yuyv(in->buffer(), out->buffer(), in->size().width(),
                                                   in->size().height(), in->stride(), out->stride());
            break;
        default:
            break;
        }

        in->deleteRef();
        return out;
    } else {
        out->deleteRef();
        return in;
    }
}
