#include <qlayout.h>
#include <q3buttongroup.h>
#include <qradiobutton.h>

#include <kdebug.h>

#include "bugsystem.h"
#include "kbbprefs.h"

#include "severityselectdialog.h"
#include "severityselectdialog.moc"

SeveritySelectDialog::SeveritySelectDialog(QWidget *parent) :
  KDialog( parent)
{
    setCaption(  i18n("Select Severity") );
    setButtons( Ok|Cancel );
    setDefaultButton( Ok );
    setModal( true );
    mButtonGroup = new Q3ButtonGroup( 1, Qt::Horizontal, i18n("Severity"), this );
    setMainWidget( mButtonGroup );

    QList<Bug::Severity> severities = Bug::severities();
    QList<Bug::Severity>::ConstIterator it;
    for( it = severities.begin(); it != severities.end(); ++it ) {
        mButtonGroup->insert(
            new QRadioButton( Bug::severityToString( *it ), mButtonGroup ), int(*it) );
    }
}

void SeveritySelectDialog::setSeverity( Bug::Severity s )
{
    mButtonGroup->setButton( s );
}

Bug::Severity SeveritySelectDialog::selectedSeverity()
{
    return (Bug::Severity)mButtonGroup->id( mButtonGroup->selected() );
}

QString SeveritySelectDialog::selectedSeverityAsString()
{
    return Bug::severityToString( selectedSeverity() );
}
