
  

#ifndef KJSEMBED_QCanvasPolygonalItem_H
#define KJSEMBED_QCanvasPolygonalItem_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class QCanvasPolygonalItem;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for QCanvasPolygonalItem methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class QCanvasPolygonalItemImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {
       Constructor_QCanvasPolygonalItem_1,

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_collidesWith_3,
       Method_setPen_4,
       Method_setBrush_5,
       Method_pen_6,
       Method_brush_7,
       Method_areaPoints_8,
       Method_areaPointsAdvanced_9,
       Method_boundingRect_10,
       Method_rtti_11,
       Method_Last = -1
   };

   QCanvasPolygonalItemImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~QCanvasPolygonalItemImp();

   /**
    * Adds the static bindings for this class to the specified Object. The
    * static bindings are the static methods and the enums of this class.
    */
   static void addStaticBindings( KJS::ExecState *exec, KJS::Object &object );

   /**
    * Adds the bindings for this class to the specified Object. The bindings
    * added are the instance methods of this class.
    */
   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static QCanvasPolygonalItem *toQCanvasPolygonalItem( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //

   KJS::Object QCanvasPolygonalItem_1( KJS::ExecState *exec, const KJS::List &args );

   //
   // Methods implemented by this class.
   //

   KJS::Value collidesWith_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setPen_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setBrush_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value pen_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value brush_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value areaPoints_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value areaPointsAdvanced_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value boundingRect_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value rtti_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   QCanvasPolygonalItem *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QCanvasPolygonalItem_H

// Local Variables:
// c-basic-offset: 4
// End:


