//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import java.util.ArrayList;

/**

 This is one of the most central classes in kdelibs as
 it provides a basic service: It knows where the files
 reside on the user's hard disk. And it's meant to be the
 only one that knows -- to make the real location as
 transparent as possible to both the user and the applications.
 To this end it insulates the application from all information
 and applications always refer to a file with a resource type
 (e.g. icon) and a filename (e.g. khexdit.xpm). In an ideal world
 the application would make no assumption where this file is and
 leave it up to KStandardDirs.findResource("apps", "Home.desktop")
 to apply this knowledge to return /opt/kde/share/applnk/Home.desktop
 or .locate("data", "kgame/background.jpg") to return
 /opt/kde/share/apps/kgame/background.jpg
 The main idea behind KStandardDirs is that there are several
 toplevel prefixes below which the files lie. One of these prefixes is
 the one where the user installed kdelibs, one is where the
 application was installed, and one is $HOME/.kde, but there
 may be even more. Under these prefixes there are several well
 defined suffixes where specific resource types are to be found.
 For example, for the resource type "html" the suffixes could be
 share/doc/HTML and share/doc/kde/HTML.
 So the search algorithm basically appends to each prefix each registered
 suffix and tries to locate the file there.
 To make the thing even more complex, it's also possible to register
 absolute paths that KStandardDirs looks up after not finding anything
 in the former steps. They can be useful if the user wants to provide
 specific directories that aren't in his $HOME/.kde directory for,
 for example, icons.
 <li><b>Standard resources that kdelibs allocates are:</b></li>

	<li>
	apps - Applications menu (.desktop files).
	</li>
	
	<li>
	cache - Cached information (e.g. favicons, web-pages)
	</li>
	
	<li>
	cgi - CGIs to run from kdehelp.
	</li>
	
	<li>
	config - Configuration files.
	</li>
	
	<li>
	data - Where applications store data.
	</li>
	
	<li>
	exe - Executables in $prefix/bin. findExe() for a function that takes $PATH into account.
	</li>
	
	<li>
	html - HTML documentation.
	</li>
	
	<li>
	icon - Icons, see KIconLoader.
	</li>
	
	<li>
	lib - Libraries.
	</li>
	
	<li>
	locale - Translation files for KLocale.
	</li>
	
	<li>
	mime - Mime types.
	</li>
	
	<li>
	module - Module (dynamically loaded library).
	</li>
	
	<li>
	qtplugins - Qt plugins (dynamically loaded objects for Qt)
	</li>
	
	<li>
	services - Services.
	</li>
	
	<li>
	servicetypes - Service types.
	</li>
	
	<li>
	scripts - Application scripting additions.
	</li>
	
	<li>
	sound - Application sounds.
	</li>
	
	<li>
	templates - Templates
	</li>
	
	<li>
	wallpaper - Wallpapers.
	</li>
	
	<li>
	tmp - Temporary files (specific for both current host and current user)
	</li>
	
	<li>
	socket - UNIX Sockets (specific for both current host and current user)
	</li>
	
	<li>
	emoticons - Emoticons themes  (Since KDE 3.4)
	</li>
	 A type that is added by the class KApplication if you use it, is
 appdata. This one makes the use of the type data a bit easier as it
 appends the name of the application.
 So while you had to .locate("data", "appname/filename") so you can
 also write .locate("appdata", "filename") if your KApplication instance
 is called "appname" (as set via KApplication's constructor or KAboutData, if
 you use the global KStandardDirs object KGlobal.dirs()).
 Please note though that you cannot use the "appdata"
 type if you intend to use it in an applet for Kicker because 'appname' would
 be "Kicker" instead of the applet's name. Therefore, for applets, you've got
 to work around this by using .locate("data", "appletname/filename").
 <b>KStandardDirs supports the following environment variables:</b>

	<li>
	KDEDIRS: This may set an additional number of directory prefixes to
	          search for resources. The directories should be separated
	          by ':'. The directories are searched in the order they are
	          specified.
	</li>
	
	<li>
	KDEDIR:  Used for backwards compatibility. As KDEDIRS but only a single
	          directory may be specified. If KDEDIRS is set KDEDIR is
	          ignored.
	</li>
	
	<li>
	KDEHOME: The directory where changes are saved to. This directory is
	          used to search for resources first. If KDEHOME is not
	          specified it defaults to "$HOME/.kde"
	</li>
	
	<li>
	KDEROOTHOME: Like KDEHOME, but used for the root user.
	          If KDEROOTHOME is not set it defaults to the .kde directory in the
	          home directory of root, usually "/root/.kde".
	          Note that the setting of $HOME is ignored in this case.
	</li>
			@author Stephan Kulow <coolo@kde.org> and Sirtaj Singh Kang <taj@kde.org>

		@version  kstandarddirs.h,v 1.122 2005/01/08 13:34:50 ogoffart

		@short Site-independent access to standard KDE directories. 
		@see KGlobalSettings

*/
public class KStandardDirs implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KStandardDirs(Class dummy){}

	/**	
		 KStandardDirs' constructor. It just initializes the caches.
				@short    KStandardDirs' constructor.
	*/
	public KStandardDirs() {
		newKStandardDirs();
	}
	private native void newKStandardDirs();
	/**	
		 Adds another search dir to front of the <code>fsstnd</code> list.
		
			<li>
			When compiling kdelibs, the prefix is added to this.
			</li>
			
			<li>
			KDEDIRS or KDEDIR is taking into account
			</li>
			
			<li>
			Additional dirs may be loaded from kdeglobals.
			</li>
				@param dir The directory to append relative paths to.
			 		@short    Adds another search dir to front of the <code>fsstnd</code> list.
	*/
	public native void addPrefix(String dir);
	/**	
		 Adds another search dir to front of the XDG_CONFIG_XXX list
		 of prefixes.
		 This prefix is only used for resources that start with "xdgconf-"
			@param dir The directory to append relative paths to.
			 		@short    Adds another search dir to front of the XDG_CONFIG_XXX list  of prefixes.
	*/
	public native void addXdgConfigPrefix(String dir);
	/**	
		 Adds another search dir to front of the XDG_DATA_XXX list
		 of prefixes.
		 This prefix is only used for resources that start with "xdgdata-"
			@param dir The directory to append relative paths to.
			 		@short    Adds another search dir to front of the XDG_DATA_XXX list  of prefixes.
	*/
	public native void addXdgDataPrefix(String dir);
	/**	
		 Adds suffixes for types.
			 You may add as many as you need, but it is advised that there
		 is exactly one to make writing definite.
		 All basic types ( kde_default) are added by addKDEDefaults(),
		 but for those you can add more relative paths as well.
			 The later a suffix is added, the higher its priority. Note, that the
		 suffix should end with / but doesn't have to start with one (as prefixes
		 should end with one). So adding a suffix for app_pics would look
		 like KGlobal.dirs().addResourceType("app_pics", "share/app/pics");
			@param type Specifies a short descriptive string to access
		 files of this type.
			@param relativename Specifies a directory relative to the root
		 of the KFSSTND.
				@return true if successful, false otherwise.
	 
		@short    Adds suffixes for types.
	*/
	public native boolean addResourceType(String type, String relativename);
	/**	
		 Adds absolute path at the end of the search path for
		 particular types (for example in case of icons where
		 the user specifies extra paths).
			 You shouldn't need this
		 function in 99% of all cases besides adding user-given
		 paths.
			@param type Specifies a short descriptive string to access files
		 of this type.
			@param absdir Points to directory where to look for this specific
		 type. Non-existant directories may be saved but pruned.
				@return true if successful, false otherwise.
	 
		@short    Adds absolute path at the end of the search path for  particular types (for example in case of icons where  the user specifies extra paths).
	*/
	public native boolean addResourceDir(String type, String absdir);
	/**	
		 Tries to find a resource in the following order:
		
			<li>
			All PREFIX/\<relativename> paths (most recent first).
			</li>
			
			<li>
			All absolute paths (most recent first).
			</li>
				 The filename should be a filename relative to the base dir
		 for resources. So is a way to get the path to libkdecore.la
		 to findResource("lib", "libkdecore.la"). KStandardDirs will
		 then look into the subdir lib of all elements of all prefixes
		 ($KDEDIRS) for a file libkdecore.la and return the path to
		 the first one it finds (e.g. /opt/kde/lib/libkdecore.la)
			@param type The type of the wanted resource
			@param filename A relative filename of the resource.
				@return A full path to the filename specified in the second
         argument, or null if not found.
	 
		@short    Tries to find a resource in the following order:
	*/
	public native String findResource(String type, String filename);
	/**	
		 Checks whether a resource is restricted as part of the KIOSK
		 framework. When a resource is restricted it means that user-
		 specific files in the resource are ignored.
			 E.g. by restricting the "wallpaper" resource, only system-wide
		 installed wallpapers will be found by this class. Wallpapers
		 installed under the $KDEHOME directory will be ignored.
			@param type The type of the resource to check
			@param relPath A relative path in the resource.
				@return True if the resource is restricted.

		@short    Checks whether a resource is restricted as part of the KIOSK  framework.
	*/
	public native boolean isRestrictedResource(String type, String relPath);
	public native boolean isRestrictedResource(String type);
	/**	
		 Returns a number that identifies this version of the resource.
		 When a change is made to the resource this number will change.
			@param type The type of the wanted resource
			@param filename A relative filename of the resource.
			@param deep If true, all resources are taken into account
		        otherwise only the one returned by findResource().
				@return A number identifying the current version of the
          resource.
	 
		@short    Returns a number that identifies this version of the resource.
	*/
	public native int calcResourceHash(String type, String filename, boolean deep);
	/**	
		 Tries to find all directories whose names consist of the
		 specified type and a relative path. So would
		 findDirs("apps", "Settings") return
		
			<li>
			/opt/kde/share/applnk/Settings/
			</li>
			
			<li>
			/home/joe/.kde/share/applnk/Settings/
			</li>
				 Note that it appends / to the end of the directories,
		 so you can use this right away as directory names.
			@param type The type of the base directory.
			@param reldir Relative directory.
				@return A list of matching directories, or an empty
         list if the resource specified is not found.
	 
		@short    Tries to find all directories whose names consist of the  specified type and a relative path.
	*/
	public native ArrayList findDirs(String type, String reldir);
	/**	
		 Tries to find the directory the file is in.
		 It works the same as findResource(), but it doesn't
		 return the filename but the name of the directory.
			 This way the application can access a couple of files
		 that have been installed into the same directory without
		 having to look for each file.
			 findResourceDir("lib", "libkdecore.la") would return the
		 path of the subdir libkdecore.la is found first in
		 (e.g. /opt/kde/lib/)
			@param type The type of the wanted resource
			@param filename A relative filename of the resource.
				@return The directory where the file specified in the second
         argument is located, or null if the type
         of resource specified is unknown or the resource
         cannot be found.
	 
		@short    Tries to find the directory the file is in.
	*/
	public native String findResourceDir(String type, String filename);
	/**	
		 Tries to find all resources with the specified type.
			 The function will look into all specified directories
		 and return all filenames in these directories.
			@param type The type of resource to locate directories for.
			@param filter Only accept filenames that fit to filter. The filter
		        may consist of an optional directory and a QRegExp
		        wildcard expression. E.g. "images\.jpg". Use null
		        if you do not want a filter.
			@param recursive Specifies if the function should decend
		        into subdirectories.
			@param unique If specified,  only return items which have
		        unique suffixes - suppressing duplicated filenames.
				@return List of all the files whose filename matches the
         specified filter.
	 
		@short    Tries to find all resources with the specified type.
	*/
	public native ArrayList findAllResources(String type, String filter, boolean recursive, boolean unique);
	public native ArrayList findAllResources(String type, String filter, boolean recursive);
	public native ArrayList findAllResources(String type, String filter);
	public native ArrayList findAllResources(String type);
	/**	
		 Tries to find all resources with the specified type.
			 The function will look into all specified directories
		 and return all filenames (full and relative paths) in
		 these directories.
			@param type The type of resource to locate directories for.
			@param filter Only accept filenames that fit to filter. The filter
		        may consist of an optional directory and a QRegExp
		        wildcard expression. E.g. "images\.jpg". Use null
		        if you do not want a filter.
			@param recursive Specifies if the function should decend
		        into subdirectories.
			@param unique If specified,  only return items which have
		        unique suffixes.
			@param relPaths The list to store the relative paths into
		        These can be used later to .locate() the file
				@return List of all the files whose filename matches the
         specified filter.
	 
		@short    Tries to find all resources with the specified type.
	*/
	public native ArrayList findAllResources(String type, String filter, boolean recursive, boolean unique, String[] relPaths);
	/**	
		 This function adds the defaults that are used by the current
		 KDE version.
			 It's a series of addResourceTypes()
		 and addPrefix() calls.
		 You normally wouldn't call this function because it's called
		 for you from KGlobal.
			 		@short    This function adds the defaults that are used by the current  KDE version.
	*/
	public native void addKDEDefaults();
	/**	
		 Reads customized entries out of the given config object and add
		 them via addResourceDirs().
			@param config The object the entries are read from. This should
		        contain global config files
				@return true if new config paths have been added
 from <code>config.</code>

		@short    Reads customized entries out of the given config object and add  them via addResourceDirs().
	*/
	public native boolean addCustomized(KConfig config);
	/**	
		 This function is used internally by almost all other function as
		 it serves and fills the directories cache.
			@param type The type of resource
				@return The list of possible directories for the specified <code>type.</code>
 The function updates the cache if possible.  If the resource
 type specified is unknown, it will return an empty list.
 Note, that the directories are assured to exist beside the save
 location, which may not exist, but is returned anyway.
	 
		@short    This function is used internally by almost all other function as  it serves and fills the directories cache.
	*/
	public native ArrayList resourceDirs(String type);
	/**	
		 This function will return a list of all the types that KStandardDirs
		 supports.
				@return All types that KDE supports
	 
		@short    This function will return a list of all the types that KStandardDirs  supports.
	*/
	public native ArrayList allTypes();
	/**	
		 Finds a location to save files into for the given type
		 in the user's home directory.
			@param type The type of location to return.
			@param suffix A subdirectory name.
		             Makes it easier for you to create subdirectories.
		   You can't pass filenames here, you _have_ to pass
		       directory names only and add possible filename in
		       that directory yourself. A directory name always has a
		       trailing slash ('/').
			@param create If set, saveLocation() will create the directories
		        needed (including those given by <code>suffix</code>).
				@return A path where resources of the specified type should be
         saved, or null if the resource type is unknown.
	 
		@short    Finds a location to save files into for the given type  in the user's home directory.
	*/
	public native String saveLocation(String type, String suffix, boolean create);
	public native String saveLocation(String type, String suffix);
	public native String saveLocation(String type);
	/**	
		 Converts an absolute path to a path relative to a certain
		 resource.
			 If "abs = .locate(resource, rel)"
		 then "rel = relativeLocation(resource, abs)" and vice versa.
			@param type The type of resource.
			@param absPath An absolute path to make relative.
				@return A relative path relative to resource <code>type</code> that
 will find <code>absPath.</code> If no such relative path exists, absPath
 will be returned unchanged.
         
		@short    Converts an absolute path to a path relative to a certain  resource.
	*/
	public native String relativeLocation(String type, String absPath);
	/**	
				 		@short
	*/
	public native String kfsstnd_prefixes();
	/**	
				 		@short
	*/
	public native String kfsstnd_xdg_conf_prefixes();
	/**	
				 		@short
	*/
	public native String kfsstnd_xdg_data_prefixes();
	/**	
		 Returns the toplevel directory in which KStandardDirs
		 will store things. Most likely $HOME/.kde
		 Don't use this function if you can use locateLocal
				@return the toplevel directory
	 
		@short    Returns the toplevel directory in which KStandardDirs  will store things.
	*/
	public native String localkdedir();
	/**	
				@return $XDG_DATA_HOME
 See also http://www.freedesktop.org/standards/basedir/draft/basedir-spec/basedir-spec.html
	 
		@short
	*/
	public native String localxdgdatadir();
	/**	
				@return $XDG_CONFIG_HOME
 See also http://www.freedesktop.org/standards/basedir/draft/basedir-spec/basedir-spec.html
	 
		@short
	*/
	public native String localxdgconfdir();
	/**	
		 Returns an ArrayList list of pathnames in the system path.
			@param pstr The path which will be searched. If this is
		 		null (default), the $PATH environment variable will
				be searched.
				@return an ArrayList list of pathnames in the system path.
	 
		@short    Returns an ArrayList list of pathnames in the system path.
	*/
	public static native ArrayList systemPaths(String pstr);
	public static native ArrayList systemPaths();
	/**	
		 Finds the executable in the system path.
			 A valid executable must
		 be a file and have its executable bit set.
			@param appname The name of the executable file for which to search.
			@param pathstr The path which will be searched. If this is
		 		null (default), the $PATH environment variable will
				be searched.
			@param ignoreExecBit If true, an existing file will be returned
					even if its executable bit is not set.
				@return The path of the executable. If it was not found,
         it will return null.

		@short    Finds the executable in the system path.
		@see #findAllExe
	*/
	public static native String findExe(String appname, String pathstr, boolean ignoreExecBit);
	public static native String findExe(String appname, String pathstr);
	public static native String findExe(String appname);
	/**	
		 Finds all occurrences of an executable in the system path.
			@param list Will be filled with the pathnames of all the
				executables found. Will be empty if the executable
				was not found.
			@param appname The name of the executable for which to
			 		search.
			@param pathstr The path list which will be searched. If this
				is 0 (default), the $PATH environment variable will
				be searched.
			@param ignoreExecBit If true, an existing file will be returned
					even if its executable bit is not set.
				@return The number of executables found, 0 if none were found.

		@short    Finds all occurrences of an executable in the system path.
		@see #findExe
	*/
	public static native int findAllExe(String[] list, String appname, String pathstr, boolean ignoreExecBit);
	public static native int findAllExe(String[] list, String appname, String pathstr);
	public static native int findAllExe(String[] list, String appname);
	/**	
		 Recursively creates still-missing directories in the given path.
			 The resulting permissions will depend on the current umask setting.
		 permission = mode & ~umask.
			@param dir Absolute path of the directory to be made.
			@param mode Directory permissions.
				@return true if successful, false otherwise
	 
		@short    Recursively creates still-missing directories in the given path.
	*/
	public static native boolean makeDir(String dir, int mode);
	public static native boolean makeDir(String dir);
	/**	
		 This returns a default relative path for the standard KDE
		 resource types. Below is a list of them so you get an idea
		 of what this is all about.
		
			<li>
			data - share/apps
			</li>
			
			<li>
			html - share/doc/HTML
			</li>
			
			<li>
			icon - share/icon
			</li>
			
			<li>
			config - share/config
			</li>
			
			<li>
			pixmap - share/pixmaps
			</li>
			
			<li>
			apps - share/applnk
			</li>
			
			<li>
			sound - share/sounds
			</li>
			
			<li>
			locale - share/locale
			</li>
			
			<li>
			services - share/services
			</li>
			
			<li>
			servicetypes - share/servicetypes
			</li>
			
			<li>
			mime - share/mimelnk
			</li>
			
			<li>
			wallpaper - share/wallpapers
			</li>
			
			<li>
			templates - share/templates
			</li>
			
			<li>
			exe - bin
			</li>
			
			<li>
			lib - lib
			</li>
					@return Static default for the specified resource.  You
          should probably be using locate() or locateLocal()
          instead.

		@short    This returns a default relative path for the standard KDE  resource types.
		@see #locate
		@see #locateLocal
	*/
	public static native String kde_default(String type);
	/**	
			 Returns the default toplevel directory where KDE is installed.
			 		@short
	*/
	public static native String kfsstnd_defaultprefix();
	/**	
			 Returns the default bin directory in which KDE executables are stored.
			 		@short
	*/
	public static native String kfsstnd_defaultbindir();
	/**	
		 Checks for existence and accessability of a file or directory.
		 Faster than creating a QFileInfo first.
			@param fullPath the path to check. IMPORTANT: must end with a slash if expected to be a directory
		                 (and no slash for a file, obviously).
				@return true if the directory exists
	 
		@short    Checks for existence and accessability of a file or directory.
	*/
	public static native boolean exists(String fullPath);
	/**	
		 Expands all symbolic links and resolves references to
		 '/./', '/../' and extra  '/' characters in <code>dirname</code>
		 and returns the canonicalized absolute pathname.
		 The resulting path will have no symbolic link, '/./'
		 or '/../' components.
				@short    Expands all symbolic links and resolves references to  '/.
	*/
	public static native String realPath(String dirname);
	/**	
		 Expands all symbolic links and resolves references to
		 '/./', '/../' and extra  '/' characters in <code>filename</code>
		 and returns the canonicalized absolute pathname.
		 The resulting path will have no symbolic link, '/./'
		 or '/../' components.
				@short    Expands all symbolic links and resolves references to  '/.
	*/
	public static native String realFilePath(String filename);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
