//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QWidget;

/**

 This dialog asks the user to enter a password. The functions you're
 probably interested in are the static methods, getPassword() and
 getNewPassword().
 <li><b>Usage example</b></li>
 <pre>
 String password;
 int result = KPasswordDialog.getPassword(password, i18n("Prompt message"));
 if (result == KPasswordDialog.Accepted)
     use(password);
 </pre>
 \image html kpassworddialog.png "KDE Password Dialog"
 <li><b>Security notes:</b></li>
 Keeping passwords in memory can be a potential security hole. You should
 handle this situation with care.

	<li>
	You may want to use disableCoreDump() to disable core dumps.
	 Core dumps are dangerous because they are an image of the process memory,
	 and thus include any passwords that were in memory.
	</li>
	
	<li>
	You should delete passwords as soon as they are not needed anymore.
	 The functions getPassword() and getNewPassword() return the
	 password as a String. I believe this is safer than a String. A String
	 stores its characters internally as 16-bit wide values, so conversions are
	 needed, both for creating the String and by using it. The temporary
	 memory used for these conversion is probably not erased. This could lead
	 to stray  passwords in memory, even if you think you erased all of them.
	</li>
			@author Geert Jansen <jansen@kde.org>
 
		@short A password input dialog.

*/
public class KPasswordDialog extends KDialogBase  {
	protected KPasswordDialog(Class dummy){super((Class) null);}
	/**	
		 This enum distinguishes the two operation modes of this dialog:
		     		@short    This enum distinguishes the two operation modes of this dialog:
	*/
	public static final int Password = 0;
	public static final int NewPassword = 1;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructs a password dialog.
			@param type : if NewPassword is given here, the dialog contains two
		        input fields, so that the user must confirm his password
		        and possible typos are detected immediately.
			@param enableKeep : if true, a check box is shown in the dialog
		        which allows the user to keep his password input for later.
			@param extraBttn : allows to show additional buttons, KDialogBase.
			@param parent Passed to lower level constructor.
			@param name Passed to lower level constructor
				@short    Constructs a password dialog.
	*/
	public KPasswordDialog(int type, boolean enableKeep, int extraBttn, QWidget parent, String name) {
		super((Class) null);
		newKPasswordDialog(type,enableKeep,extraBttn,parent,name);
	}
	private native void newKPasswordDialog(int type, boolean enableKeep, int extraBttn, QWidget parent, String name);
	public KPasswordDialog(int type, boolean enableKeep, int extraBttn, QWidget parent) {
		super((Class) null);
		newKPasswordDialog(type,enableKeep,extraBttn,parent);
	}
	private native void newKPasswordDialog(int type, boolean enableKeep, int extraBttn, QWidget parent);
	public KPasswordDialog(int type, boolean enableKeep, int extraBttn) {
		super((Class) null);
		newKPasswordDialog(type,enableKeep,extraBttn);
	}
	private native void newKPasswordDialog(int type, boolean enableKeep, int extraBttn);
	/**	
		 Construct a password dialog. Essentially the same as above but allows the
		 icon in the password dialog to be set via <code>iconName.</code>
			@param type if NewPassword is given here, the dialog contains two
		 input fields, so that the user must confirm his password
		 and possible typos are detected immediately
			@param enableKeep : if true, a check box is shown in the dialog
		        which allows the user to keep his password input for later.
			@param extraBttn : allows to show additional buttons.
			@param iconName the name of the icon to be shown in the dialog. If empty,
		 a default icon is used
			@param parent Passed to lower level constructor.
			@param name Passed to lower level constructor
				@short    Construct a password dialog.
	*/
	public KPasswordDialog(int type, boolean enableKeep, int extraBttn, String iconName, QWidget parent, String name) {
		super((Class) null);
		newKPasswordDialog(type,enableKeep,extraBttn,iconName,parent,name);
	}
	private native void newKPasswordDialog(int type, boolean enableKeep, int extraBttn, String iconName, QWidget parent, String name);
	public KPasswordDialog(int type, boolean enableKeep, int extraBttn, String iconName, QWidget parent) {
		super((Class) null);
		newKPasswordDialog(type,enableKeep,extraBttn,iconName,parent);
	}
	private native void newKPasswordDialog(int type, boolean enableKeep, int extraBttn, String iconName, QWidget parent);
	public KPasswordDialog(int type, boolean enableKeep, int extraBttn, String iconName) {
		super((Class) null);
		newKPasswordDialog(type,enableKeep,extraBttn,iconName);
	}
	private native void newKPasswordDialog(int type, boolean enableKeep, int extraBttn, String iconName);
	/**	
		 Sets the password prompt.
		     		@short    Sets the password prompt.
	*/
	public native void setPrompt(String prompt);
	/**	
		 Returns the password prompt.
		     		@short    Returns the password prompt.
	*/
	public native String prompt();
	/**	
		 Adds a line of information to the dialog.
		     		@short    Adds a line of information to the dialog.
	*/
	public native void addLine(String key, String value);
	/**	
		 Allow empty passwords? - Default: false
				@short    Allow empty passwords? - Default: false
	*/
	public native void setAllowEmptyPasswords(boolean allowed);
	/**	
		 Allow empty passwords?
				@short    Allow empty passwords?
	*/
	public native boolean allowEmptyPasswords();
	/**	
		 Minimum acceptable password length.
		 Default: If empty passwords are forbidden, 1;
		          Otherwise, 0.
			@param minLength : The new minimum password length
				@short    Minimum acceptable password length.
	*/
	public native void setMinimumPasswordLength(int minLength);
	/**	
		 Minimum acceptable password length.
				@short    Minimum acceptable password length.
	*/
	public native int minimumPasswordLength();
	/**	
		 Maximum acceptable password length.  Limited to 199.
		 Default: No limit, i.e. -1
			@param maxLength : The new maximum password length.
				@short    Maximum acceptable password length.
	*/
	public native void setMaximumPasswordLength(int maxLength);
	/**	
		 Maximum acceptable password length.
				@short    Maximum acceptable password length.
	*/
	public native int maximumPasswordLength();
	/**	
		 Password length that is expected to be reasonably safe.
			 Default: 8 - the standard UNIX password length
			@param reasonableLength : The new reasonable password length.
				@short    Password length that is expected to be reasonably safe.
	*/
	public native void setReasonablePasswordLength(int maxLength);
	/**	
		 Password length that is expected to be reasonably safe.
				@short    Password length that is expected to be reasonably safe.
	*/
	public native int reasonablePasswordLength();
	/**	
		 Set the password strength level below which a warning is given
		 Value is in the range 0 to 99. Empty passwords score 0;
		 non-empty passwords score up to 100, depending on their length and whether they
		 contain numbers, mixed case letters and punctuation.
			 Default: 1 - warn if the password has no discernable strength whatsoever
			@param warningLevel : The level below which a warning should be given.
				@short    Set the password strength level below which a warning is given  Value is in the range 0 to 99.
	*/
	public native void setPasswordStrengthWarningLevel(int warningLevel);
	/**	
		 Password strength level below which a warning is given
				@short    Password strength level below which a warning is given
	*/
	public native int passwordStrengthWarningLevel();
	/**	
		 Returns the password entered. The memory is freed in the destructor,
		 so you should make a copy.
		     		@short    Returns the password entered.
	*/
	public native String password();
	/**	
		 Clears the password input field. You might want to use this after the
		 user failed to enter the correct password.
				@short    Clears the password input field.
	*/
	public native void clearPassword();
	/**	
		 Returns true if the user wants to keep the password.
		     		@short    Returns true if the user wants to keep the password.
	*/
	public native boolean keep();
	/**	
		 Pops up the dialog, asks the user for a password, and returns it.
			@param password The password is returned in this reference parameter.
			@param prompt A prompt for the password. This can be a few lines of
		 information. The text is word broken to fit nicely in the dialog.
			@param keep Enable/disable a checkbox controlling password keeping.
		 If you pass a null pointer, or a pointer to the value 0, the checkbox
		 is not shown. If you pass a pointer to a nonzero value, the checkbox
		 is shown and the result is stored in keep.
				@return Result code: Accepted or Rejected.
     
		@short    Pops up the dialog, asks the user for a password, and returns it.
	*/
	public static native int getPassword(StringBuffer password, String prompt, int[] keep);
	public static native int getPassword(StringBuffer password, String prompt);
	/**	
		 Pops up the dialog, asks the user for a password and returns it. The
		 user has to enter the password twice to make sure it was entered
		 correctly.
			@param password The password is returned in this reference parameter.
			@param prompt A prompt for the password. This can be a few lines of
		 information. The text is word broken to fit nicely in the dialog.
				@return Result code: Accepted or Rejected.
     
		@short    Pops up the dialog, asks the user for a password and returns it.
	*/
	public static native int getNewPassword(StringBuffer password, String prompt);
	/**	
		 Static helper function that disables core dumps.
		     		@short    Static helper function that disables core dumps.
	*/
	public static native void disableCoreDumps();
	/**	
		 Virtual function that can be overridden to provide password
		 checking in derived classes. It should return <code>true</code> if the
		 password is valid, <code>false</code> otherwise.
		     		@short    Virtual function that can be overridden to provide password  checking in derived classes.
	*/
	protected native boolean checkPassword(String arg1);
	protected native void slotOk();
	protected native void slotCancel();
	protected native void slotKeep(boolean arg1);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
