//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QRect;
import org.kde.qt.QHideEvent;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QPixmap;
import org.kde.qt.QPoint;
import org.kde.qt.QMouseEvent;
import org.kde.qt.QWidget;
import org.kde.qt.QVBox;
import org.kde.qt.QFrame;

/**

 The simplest uses of KPassivePopup are by using the various message() static
 methods. The position the popup appears at depends on the type of the parent window:

	<li>
	Normal Windows: The popup is placed adjacent to the icon of the window.
	</li>
	
	<li>
	System Tray Windows: The popup is placed adjact to the system tray window itself.
	</li>
	
	<li>
	Skip Taskbar Windows: The popup is placed adjact to the window
	     itself if it is visible, and at the edge of the desktop otherwise.
	</li>
	 The most basic use of KPassivePopup displays a popup containing a piece of text:
 <pre>
    KPassivePopup.message( "This is the message", this );
 </pre>
 We can create popups with titles and icons too, as this example shows:
 <pre>
    QPixmap px;
    px.load( "hi32-app-logtracker.png" );
    KPassivePopup.message( "Some title", "This is the main text", px, this );
 </pre>
 For more control over the popup, you can use the setView(QWidget ) method
 to create a custom popup.
 <pre>
    KPassivePopup pop = new KPassivePopup( parent );
    QVBox vb = new QVBox( pop );
     new QLabel( vb, "<b>Isn't this great?</b>" );
    QHBox box = new QHBox( vb );
     new QPushButton( box, "Yes" );
     new QPushButton( box, "No" );
    pop.setView( vb );
    pop.show();
 </pre>
 See {@link KPassivePopupSignals} for signals emitted by KPassivePopup
		@author Richard Moore, rich@kde.org
 
		@version  kpassivepopup.h,v 1.20 2004/09/09 15:23:53 faure

		@short A dialog-like popup that displays messages without interupting the user.

*/
public class KPassivePopup extends QFrame  {
	protected KPassivePopup(Class dummy){super((Class) null);}
	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Creates a popup for the specified widget.
		     		@short    Creates a popup for the specified widget.
	*/
	public KPassivePopup(QWidget parent, String name, int f) {
		super((Class) null);
		newKPassivePopup(parent,name,f);
	}
	private native void newKPassivePopup(QWidget parent, String name, int f);
	public KPassivePopup(QWidget parent, String name) {
		super((Class) null);
		newKPassivePopup(parent,name);
	}
	private native void newKPassivePopup(QWidget parent, String name);
	public KPassivePopup(QWidget parent) {
		super((Class) null);
		newKPassivePopup(parent);
	}
	private native void newKPassivePopup(QWidget parent);
	public KPassivePopup() {
		super((Class) null);
		newKPassivePopup();
	}
	private native void newKPassivePopup();
	/**	
		 Creates a popup for the specified window.
		     		@short    Creates a popup for the specified window.
	*/
	public KPassivePopup(long parent, String name, int f) {
		super((Class) null);
		newKPassivePopup(parent,name,f);
	}
	private native void newKPassivePopup(long parent, String name, int f);
	public KPassivePopup(long parent, String name) {
		super((Class) null);
		newKPassivePopup(parent,name);
	}
	private native void newKPassivePopup(long parent, String name);
	public KPassivePopup(long parent) {
		super((Class) null);
		newKPassivePopup(parent);
	}
	private native void newKPassivePopup(long parent);
	/**	
		 Sets the main view to be the specified widget (which must be a child of the popup).
		     		@short    Sets the main view to be the specified widget (which must be a child of the popup).
	*/
	public native void setView(QWidget child);
	/**	
		 Creates a standard view then calls setView(QWidget) .
		     		@short    Creates a standard view then calls setView(QWidget ) .
	*/
	public native void setView(String caption, String text);
	public native void setView(String caption);
	/**	
		 Creates a standard view then calls setView(QWidget) .
		     		@short    Creates a standard view then calls setView(QWidget ) .
	*/
	public native void setView(String caption, String text, QPixmap icon);
	/**	
		 Returns a widget that is used as standard view if one of the 
		 setView() methods taking the String arguments is used.
		 You can use the returned widget to customize the passivepopup while 
		 keeping the look similar to the "standard" passivepopups.
			 After customizing the widget, pass it to setView( QWidget )
			@param caption The window caption (title) on the popup
			@param text The text for the popup
			@param icon The icon to use for the popup
			@param parent The parent widget used for the returned QVBox. If left null,
		 then "this", i.e. the passive popup object will be used.
				@return a QVBox containing the given arguments, looking like the
 standard passivepopups.

		@short    Returns a widget that is used as standard view if one of the   setView() methods taking the String arguments is used.
		@see #setView(
		@see org.kde.qt.QWidget
		@see #setView(
		@see #const
		@see #const
		@see #setView(
		@see #const
		@see #const
		@see #const
		@see org.kde.qt.QPixmap&
	*/
	public native QVBox standardView(String caption, String text, QPixmap icon, QWidget parent);
	public native QVBox standardView(String caption, String text, QPixmap icon);
	/**	
		 Returns the main view.
		     		@short    Returns the main view.
	*/
	public native QWidget view();
	/**	
		 Returns the delay before the popup is removed automatically.
		     		@short    Returns the delay before the popup is removed automatically.
	*/
	public native int timeout();
	/**	
		 Enables / disables auto-deletion of this widget when the #timeout
		 occurs.
		 The default is false. If you use the class-methods message(),
		 auto-delection is turned on by default.
		     		@short    Enables / disables auto-deletion of this widget when the #timeout  occurs.
	*/
	public native void setAutoDelete(boolean autoDelete);
	/**	
				@return true if the widget auto-deletes itself when the #timeout occurs.

		@short   
		@see #setAutoDelete
	*/
	public native boolean autoDelete();
	/**	
		 Sets the delay for the popup is removed automatically. Setting the delay to 0
		 disables the #timeout, if you're doing this, you may want to connect the
		 clicked() signal to the hide() slot.
		 Setting the delay to -1 makes it use the default value.
		     		@short    Sets the delay for the popup is removed automatically.
	*/
	public native void setTimeout(int delay);
	/**	
		 Reimplemented to reposition the popup.
		     		@short    Reimplemented to reposition the popup.
	*/
	public native void show();
	/**	
		 Convenience method that displays popup with the specified  message  beside the
		 icon of the specified widget.
		 Note that the returned object is destroyed when it is hidden.
				@short    Convenience method that displays popup with the specified  message  beside the  icon of the specified widget.
		@see #setAutoDelete
	*/
	public static native KPassivePopup message(String text, QWidget parent, String name);
	public static native KPassivePopup message(String text, QWidget parent);
	/**	
		 Convenience method that displays popup with the specified caption and message
		 beside the icon of the specified widget.
		 Note that the returned object is destroyed when it is hidden.
				@short    Convenience method that displays popup with the specified caption and message  beside the icon of the specified widget.
		@see #setAutoDelete
	*/
	public static native KPassivePopup message(String caption, String text, QWidget parent, String name);
	public static native KPassivePopup message(String caption, String text, QWidget parent);
	/**	
		 Convenience method that displays popup with the specified icon, caption and
		 message beside the icon of the specified widget.
		 Note that the returned object is destroyed when it is hidden.
				@short    Convenience method that displays popup with the specified icon, caption and  message beside the icon of the specified widget.
		@see #setAutoDelete
	*/
	public static native KPassivePopup message(String caption, String text, QPixmap icon, QWidget parent, String name, int timeout);
	public static native KPassivePopup message(String caption, String text, QPixmap icon, QWidget parent, String name);
	public static native KPassivePopup message(String caption, String text, QPixmap icon, QWidget parent);
	/**	
		 Convenience method that displays popup with the specified icon, caption and
		 message beside the icon of the specified window.
		 Note that the returned object is destroyed when it is hidden.
				@short    Convenience method that displays popup with the specified icon, caption and  message beside the icon of the specified window.
		@see #setAutoDelete
	*/
	public static native KPassivePopup message(String caption, String text, QPixmap icon, long parent, String name, int timeout);
	public static native KPassivePopup message(String caption, String text, QPixmap icon, long parent, String name);
	public static native KPassivePopup message(String caption, String text, QPixmap icon, long parent);
	/**	
		 This method positions the popup.
		     		@short    This method positions the popup.
	*/
	protected native void positionSelf();
	/**	
		 Reimplemented to destroy the object when autoDelete() is
		 enabled.
		     		@short    Reimplemented to destroy the object when autoDelete() is  enabled.
	*/
	protected native void hideEvent(QHideEvent arg1);
	/**	
		 Moves the popup to be adjacent to the icon of the specified rectangle.
		     		@short    Moves the popup to be adjacent to the icon of the specified rectangle.
	*/
	protected native void moveNear(QRect target);
	/**	
		 Reimplemented to detect mouse clicks.
		     		@short    Reimplemented to detect mouse clicks.
	*/
	protected native void mouseReleaseEvent(QMouseEvent e);
	/**	
		 If no relative window (eg taskbar button, system tray window) is
		 available, use this rectangle (pass it to moveNear()).
		 Basically KWinModule.workArea() with width and height set to 0
		 so that moveNear uses the upper-left position.
				@return The QRect to be passed to moveNear() if no other is
 available.
     
		@short    If no relative window (eg taskbar button, system tray window) is  available, use this rectangle (pass it to moveNear()).
	*/
	protected native QRect defaultArea();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
